package org.seasar.framework.container.util;

import java.lang.reflect.Method;

import org.codehaus.backport175.reader.Annotation;
import org.codehaus.backport175.reader.Annotations;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.Component;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.Inject;
import org.seasar.framework.container.NoInject;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.util.ClassUtil;

/**
 * @author higa
 */
public class Backport175Util {
    
    private Backport175Util() {
    }
    
    public static ComponentDef createComponentDef(String className) {
        return createComponentDef(ClassUtil.forName(className));
    }

    public static ComponentDef createComponentDef(Class componentClass) {
        Annotation annotation = Annotations.getAnnotation(Component.class, componentClass);
        if (annotation == null) {
            return new ComponentDefImpl(componentClass);
        }
        Component component = (Component) annotation;
        String name = component.name();
        ComponentDef componentDef = new ComponentDefImpl(componentClass, name);
        String instanceMode = component.instance();
        if (instanceMode != null) {
            componentDef.setInstanceMode(instanceMode);
        }
        String autoBindingMode = component.autoBinding();
        if (autoBindingMode != null) {
            componentDef.setAutoBindingMode(autoBindingMode);
        }
        return componentDef;
    }
    
    
    public static ComponentDef createComponentDefWithDI(String className) {
        return createComponentDefWithDI(ClassUtil.forName(className));
    }
    
    public static ComponentDef createComponentDefWithDI(Class componentClass) {
        ComponentDef componentDef = createComponentDef(componentClass);
        appendDI(componentDef);
        return componentDef;
    }
    
    public static void appendDI(ComponentDef componentDef) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(componentDef.getComponentClass());
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (!pd.hasWriteMethod()) {
                continue;
            }
            PropertyDef propDef = createPropertyDef(pd);
            if (propDef == null) {
                continue;
            }
            componentDef.addPropertyDef(propDef);
        }
    }
    
    public static PropertyDef createPropertyDef(PropertyDesc propertyDesc) {
        Method method = propertyDesc.getWriteMethod();
        Inject inject = (Inject) Annotations.getAnnotation(Inject.class, method);
        if (inject != null) {
            String value = inject.value();
            if (value == null) {
                return null;
            }
            PropertyDef pd = new PropertyDefImpl(propertyDesc.getPropertyName());
            pd.setExpression(value);
            return pd;
        }
        NoInject noInject = (NoInject) Annotations.getAnnotation(NoInject.class, method);
        if (noInject != null) {
            return new PropertyDefImpl(propertyDesc.getPropertyName(), true);
        }
        return null;
    }
}