/*
 */
package org.seasar.framework.container.auto;

import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.AspectDefImpl;

/**
 * @author higa
 *
 */
public class InterceptorAutoRegister extends AutoRegister {

    private String interceptorName;
    
    public void setInterceptorName(String interceptorName) {
        this.interceptorName = interceptorName;
    }

    public void registAll() {
        S2Container container = getContainer();
        for (int i = 0; i < container.getComponentDefSize(); ++i) {
            ComponentDef cd = container.getComponentDef(i);
            regist(cd);
        }
    }
    
    protected void regist(ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        String className = componentClass.getName();
        for (int i = 0; i < getClassPatternSize(); ++i) {
            ClassPattern cp = getClassPattern(i);
            String packageName = cp.getPackageName();
            if (!className.startsWith(packageName)) {
                continue;
            }
            String shortClassName = className.substring(
                    packageName.length() + 1);
            if (cp.isApplied(shortClassName)) {
                registInterceptor(componentDef);
                return;
            }
        }
    }
    
    protected void registInterceptor(ComponentDef componentDef) {
        AspectDef aspectDef = new AspectDefImpl();
        aspectDef.setExpression(interceptorName);
        componentDef.addAspectDef(aspectDef);
    }
}