/*
 */
package org.seasar.framework.container.auto;

import java.io.File;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.util.Backport175Util;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

/**
 * @author higa
 *
 */
public class FileSystemComponentAutoRegister extends AutoRegister {

    private static final String CLASS_SUFFIX = ".class";

    private String fileNameOfRoot = "app.dicon";
    
    public void setFileNameOfRoot(String fileNameOfRoot) {
        this.fileNameOfRoot = fileNameOfRoot;
    }

    public void registAll() {
        for (int i = 0; i < getClassPatternSize(); ++i) {
            ClassPattern cp = getClassPattern(i);
            regist(cp);
        }
    }
    
    protected void regist(ClassPattern classPattern) {
        String packageName = classPattern.getPackageName();
        File packageDir = getPackageDir(packageName);
        String[] fileNames = packageDir.list();
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i];
            if (!fileName.endsWith(CLASS_SUFFIX)) {
                continue;
            }
            String shortClassName = fileName.substring(0, fileName.length() - CLASS_SUFFIX.length());
            if (classPattern.isApplied(shortClassName)) {
                String className = classPattern.convertToClassName(shortClassName);
                ComponentDef cd = Backport175Util.createComponentDef(className);
                if (hasComponentDef(cd.getComponentName())) {
                    continue;
                }
                Backport175Util.appendDI(cd);
                getContainer().register(cd);
            }
        }
    }
    
    protected File getPackageDir(String packageName) {
        File packageDir = getRootDir();
        if (packageName != null) {
            String[] names = StringUtil.split(packageName, ".");
            for (int i = 0; i < names.length; i++) {
                packageDir = new File(packageDir, names[i]);
            }
        }
        return packageDir;
    }
    
    protected File getRootDir() {
        return ResourceUtil.getResourceAsFile(fileNameOfRoot).getParentFile();
    }
}