/*
 */
package org.seasar.framework.container.auto;

import java.util.regex.Pattern;

import org.seasar.framework.util.StringUtil;

/**
 * @author higa
 *
 */
public class ClassPattern {

    private String packageName;
    
    private Pattern[] shortClassNamePatterns;
    
    public ClassPattern() {
    }
    
    public ClassPattern(String packageName, String shortClassName) {
        setPackageName(packageName);
        setShortClassName(shortClassName);
    }
    
    public String getPackageName() {
        return packageName;
    }
    
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }
    
    public void setShortClassName(String shortClassName) {
        String[] classNames = StringUtil.split(shortClassName, ",");
        shortClassNamePatterns = new Pattern[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            String s = classNames[i].trim();
            shortClassNamePatterns[i] = Pattern.compile(s);
        }
    }
    
    public boolean isApplied(String shortClassName) {
        if (shortClassNamePatterns == null) {
            return true;
        }
        for (int i = 0; i < shortClassNamePatterns.length; ++i) {
            if (shortClassNamePatterns[i].matcher(shortClassName).matches()) {
                return true;
            }
        }
        return false;
    }
    
    public String convertToClassName(String shortClassName) {
        if (packageName == null) {
            return shortClassName;
        }
        return packageName + "." + shortClassName;
    }
}
