/*
 */
package org.seasar.framework.container.auto;

import java.util.ArrayList;
import java.util.List;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;

/**
 * @author higa
 *
 */
public class AutoRegister {

    private S2Container container;
    
    private List classPatterns = new ArrayList();
    
    public S2Container getContainer() {
        return container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }
    
    public int getClassPatternSize() {
        return classPatterns.size();
    }
    
    public ClassPattern getClassPattern(int index) {
        return (ClassPattern) classPatterns.get(index);
    }
    
    public void addClassPattern(String packageName,
            String shortClassName) {
        
        addClassPattern(new ClassPattern(packageName, shortClassName));
    }
    
    public void addClassPattern(ClassPattern classPattern) {
        classPatterns.add(classPattern);
    }

    protected boolean hasComponentDef(String name) {
        return findComponentDef(name) != null;
    }

    protected ComponentDef findComponentDef(String name) {
        if (name == null) {
            return null;
        }
        S2Container container = getContainer();
        for (int i = 0; i < container.getComponentDefSize(); ++i) {
            ComponentDef cd = container.getComponentDef(i);
            if (name.equals(cd.getComponentName())) {
                return cd;
            }
        }
        return null;
    }
}