package org.seasar.extension.unit;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.Servlet;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;

import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.DataReader;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.DataWriter;
import org.seasar.extension.dataset.impl.SqlDeleteTableWriter;
import org.seasar.extension.dataset.impl.SqlReloadReader;
import org.seasar.extension.dataset.impl.SqlReloadTableReader;
import org.seasar.extension.dataset.impl.SqlTableReader;
import org.seasar.extension.dataset.impl.SqlWriter;
import org.seasar.extension.dataset.impl.XlsReader;
import org.seasar.extension.dataset.impl.XlsWriter;
import org.seasar.extension.dataset.types.ColumnTypes;
import org.seasar.extension.jdbc.UpdateHandler;
import org.seasar.extension.jdbc.impl.BasicUpdateHandler;
import org.seasar.extension.mock.servlet.MockHttpServletRequest;
import org.seasar.extension.mock.servlet.MockHttpServletResponse;
import org.seasar.extension.mock.servlet.MockHttpServletResponseImpl;
import org.seasar.extension.mock.servlet.MockServlet;
import org.seasar.extension.mock.servlet.MockServletConfig;
import org.seasar.extension.mock.servlet.MockServletConfigImpl;
import org.seasar.extension.mock.servlet.MockServletContext;
import org.seasar.extension.mock.servlet.MockServletContextImpl;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ContainerConstants;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.util.Backport175Util;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.DataSourceUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.FileOutputStreamUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

/**
 * <p>
 * JUnitTestCasegAS2geXgyȂ߂ NXłB
 * </p>
 * 
 * <p>
 * eeXg\bhsۂɂ́Aȉ̏ԂŏȂ܂B eXg\bh֌W鏈܂̂ŁAłtestXxx()Ƃ
 * eXg\bhsƉ肵܂B
 * </p>
 * 
 * <ol>
 * <li>S2Container̃CX^X쐬܂B</li>
 * <li>setUp()s܂B</li>
 * <li>setUpXxxƂÕ\bhΎs܂B</li>
 * <li>S2Container܂B</li>
 * <li>"j2ee.dataSource"ƂÕf[^\[XRei擾܂B</li>
 * <li>setUpAfterContainerInit()s܂B</li>
 * <li>tB[hDIȂ܂B</li>
 * <li>testXxx()s܂B</li>
 * <li>tearDownBeforeContainerDestroy()s܂B</li>
 * <li>f[^\[XJ܂B</li>
 * <li>S2ContaineȑIȂ܂B</li>
 * <li>tearDownXxx()ƂÕ\bhΎs܂B</li>
 * <li>tearDown()s܂B</li>
 * </ol>
 * 
 * <p>
 * setUp()A܂setUpXxx()include("j2ee.dicon")sAeXg
 * \bh̍Ō"Tx"ƕtƁAeXg\bh̎sOɃgUN VJnAeXg\bh̏IɃgUNV[obN
 * ܂BDB̃R[hύX悤ȃeXg̏ꍇɂ̋@\𗘗pƁA N[AbvsvɂȂ܂B
 * </p>
 * 
 * @author higa
 * @see junit.framework.TestCase
 */
public class S2TestCase extends TestCase {

	private static final String DATASOURCE_NAME = "j2ee"
			+ ContainerConstants.NS_SEP + "dataSource";

	private S2Container container_;

	private Servlet servlet_;

	private MockServletConfig servletConfig_;

	private MockServletContext servletContext_;

	private MockHttpServletRequest request_;

	private MockHttpServletResponse response_;

	private DataSource dataSource_;

	private Connection connection_;

	private DatabaseMetaData dbMetaData_;

	private List bindedFields_;

	/**
	 * <p>
	 * VAC[[VLɂ邽߂̃ftHgRXgN^łB
	 * </p>
	 * <p>
	 * <code>TestCase#setName()</code>
	 * \bhĂяo邱ƂȂ̃RXgN^g邱Ƃ͈Ӑ}Ă܂B
	 * </p>
	 *  
	 */
	public S2TestCase() {
	}

	/**
	 * <p>
	 * w肳ꂽOŃeXgP[X쐬܂B
	 * </p>
	 * 
	 * @param name
	 *            eXgP[X̖O
	 */
	public S2TestCase(String name) {
		super(name);
	}

	/**
	 * <p>
	 * eXgP[XۗLS2Rei擾܂B
	 * </p>
	 * 
	 * @return S2Rei
	 */
	public S2Container getContainer() {
		return container_;
	}

	/**
	 * <p>
	 * R|[lgw肵S2ReiR|[lg擾 ܂B
	 * </p>
	 * <p>
	 * w肵OR|[lgo^ĂȂꍇnull Ԃ܂B
	 * </p>
	 * 
	 * @param componentName
	 *            擾R|[lg
	 * @return w肵OR|[lg
	 * @see org.seasar.framework.container.S2Container#getComponent(java.lang.Object)
	 */
	public Object getComponent(String componentName) {
		return container_.getComponent(componentName);
	}

	/**
	 * <p>
	 * NXw肵S2ReiR|[lg擾܂B
	 * </p>
	 * <p>
	 * C^[tF[Xw肵ꍇ͂̃C^[tF[X R|[lgANXw肵ꍇ͂̃NX̃NX
	 * eɎqNX̃R|[lg擾܂B
	 * </p>
	 * <p>
	 * w肵NX̃R|[lgo^ĂȂꍇnull Ԃ܂B
	 * </p>
	 * 
	 * @param componentClass
	 *            擾NX
	 * @return w肵NX̃R|[lg
	 * @see org.seasar.framework.container.S2Container#getComponent(java.lang.Object)
	 */
	public Object getComponent(Class componentClass) {
		return container_.getComponent(componentClass);
	}

	/**
	 * <p>
	 * R|[lgw肵S2ReiR|[lg` 擾܂B
	 * </p>
	 * 
	 * @param componentName
	 *            擾R|[lg
	 * @return w肵OR|[lg`
	 * @see org.seasar.framework.container.S2Container#getComponentDef(java.lang.Object)
	 */
	public ComponentDef getComponentDef(String componentName) {
		return container_.getComponentDef(componentName);
	}

	/**
	 * <p>
	 * NXw肵S2ReiR|[lg`擾܂B
	 * </p>
	 * 
	 * @param componentClass
	 *            擾NX
	 * @return w肵NX̃R|[lg`
	 * @see org.seasar.framework.container.S2Container#getComponentDef(java.lang.Object)
	 */
	public ComponentDef getComponentDef(Class componentClass) {
		return container_.getComponentDef(componentClass);
	}
    
    /**
     * <p>
     * NXw肵ăAme[VlR|[lg`𐶐܂B
     * </p>
     * 
     * @param componentClass
     *            擾NX
     * @return w肵NX̃R|[lg`
     */
    public ComponentDef createComponentDef(Class componentClass) {
        return Backport175Util.createComponentDefWithDI(componentClass);
    }

	/**
	 * <p>
	 * NXS2ReiɃR|[lg`Ƃēo^܂B
	 * </p>
	 * 
	 * @param componentClass
	 *            R|[lg̃NX
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Class)
	 */
	public void register(Class componentClass) {
		container_.register(componentClass);
	}

	/**
	 * <p>
	 * NXS2ReiɖOtR|[lg`Ƃēo^ ܂B
	 * </p>
	 * 
	 * @param componentClass
	 *            R|[lg̃NX
	 * @param componentName
	 *            R|[lg̖O
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Class,
	 *      java.lang.String)
	 */
	public void register(Class componentClass, String componentName) {
		container_.register(componentClass, componentName);
	}

	/**
	 * <p>
	 * IuWFNgS2ReiɃR|[lgƂēo^܂B
	 * </p>
	 * <p>
	 * L[̓IuWFNg̃NXɂȂ܂B
	 * </p>
	 * 
	 * @param component
	 *            R|[lgƂēo^IuWFNg
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Object)
	 */
	public void register(Object component) {
		container_.register(component);
	}

	/**
	 * <p>
	 * IuWFNgS2ReiɖOtR|[lgƂēo^ ܂B
	 * </p>
	 * 
	 * @param component
	 *            R|[lgƂēo^IuWFNg
	 * @param componentName
	 *            R|[lg
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Object,
	 *      java.lang.String)
	 */
	public void register(Object component, String componentName) {
		container_.register(component, componentName);
	}

	/**
	 * <p>
	 * S2ReiɃR|[lg`o^܂B
	 * </p>
	 * 
	 * @param componentDef
	 *            o^R|[lg`
	 * @see org.seasar.framework.container.S2Container#register(org.seasar.framework.container.ComponentDef)
	 */
	public void register(ComponentDef componentDef) {
		container_.register(componentDef);
	}

	/**
	 * <p>
	 * ݒt@C̃pXw肵ĎqReiinclude܂B
	 * </p>
	 * <p>
	 * pXCLASSPATHŎw肳ĂfBNg[gƂ ݒt@C̐΃pXAt@Ĉ݂w肵܂B
	 * </p>
	 * <p>
	 * t@Ĉ݂̏ꍇAeXgP[XƓpbP[Wɂ Ƃ܂B
	 * </p>
	 * 
	 * @param path
	 *            qRei̐ݒt@C̃pX
	 */
	public void include(String path) {
		S2ContainerFactory.include(container_, convertPath(path));
	}

	private String convertPath(String path) {
		if (ResourceUtil.getResourceNoException(path) != null) {
			return path;
		} else {
			String prefix = getClass().getName().replace('.', '/').replaceFirst("/[^/]+$", "");
			return prefix + "/" + path;
		}
	}

	/**
	 * <p>
	 * f[^\[X擾܂B
	 * </p>
	 * 
	 * @return f[^\[X
	 */
	public DataSource getDataSource() {
		if (dataSource_ == null) {
			throw new EmptyRuntimeException("dataSource");
		}
		return dataSource_;
	}

	/**
	 * <p>
	 * f[^\[XRlNV擾܂B
	 * </p>
	 * 
	 * @return f[^\[X擾RlNV
	 */
	public Connection getConnection() {
		if (connection_ != null) {
			return connection_;
		}
		connection_ = DataSourceUtil.getConnection(getDataSource());
		return connection_;
	}

	/**
	 * <p>
	 * RlNṼf[^x[X^f[^擾܂B
	 * </p>
	 * 
	 * @return RlNṼf[^x[X^f[^
	 */
	public DatabaseMetaData getDatabaseMetaData() {
		if (dbMetaData_ != null) {
			return dbMetaData_;
		}
		dbMetaData_ = ConnectionUtil.getMetaData(getConnection());
		return dbMetaData_;
	}

	/**
	 * <p>
	 * Excelt@Cǂ݁ADataSet쐬܂B
	 * </p>
	 * <p>
	 * V[ge[uAsڂJAsڈȍ~f[^ Ƃēǂݍ݂܂B
	 * </p>
	 * 
	 * <p>
	 * pXCLASSPATHŎw肳ĂfBNg[gƂ ݒt@C̐΃pXAt@Ĉ݂w肵܂Bt@C
	 * ݂̂̏ꍇAeXgP[XƓpbP[Wɂ̂Ƃ܂B
	 * </p>
	 * 
	 * @param path
	 *            Excelt@C̃pX
	 * @return Excelt@C̓e쐬DataSet
	 * @see org.seasar.extension.dataset.impl.XlsReader#read()
	 */
	public DataSet readXls(String path) {
		DataReader reader = new XlsReader(convertPath(path));
		return reader.read();
	}

	/**
	 * <p>
	 * DataSet̓eAExcelt@C쐬܂B
	 * </p>
	 * <p>
	 * V[gɃe[uAsڂɃJAsڈȍ~Ƀf[^ ݂܂B
	 * </p>
	 * 
	 * <p>
	 * pXCLASSPATHŎw肳ĂfBNg[gƂ ݒt@C̐΃pXAt@Ĉ݂w肵܂Bt@C
	 * ݂̂̏ꍇAeXgP[XƓpbP[Wɂ̂Ƃ܂B
	 * </p>
	 * 
	 * @param path
	 *            Excelt@C̃pX
	 * @param dataSet
	 *            Excelt@CɏޓeDataSet
	 * @see org.seasar.extension.dataset.impl.XlsWriter#write(DataSet)
	 */
	public void writeXls(String path, DataSet dataSet) {
		File dir = ResourceUtil.getBuildDir(getClass());
		File file = new File(dir, convertPath(path));
		DataWriter writer = new XlsWriter(FileOutputStreamUtil.create(file));
		writer.write(dataSet);
	}

	/**
	 * <p>
	 * DataSetDBɏ݂܂B
	 * </p>
	 * 
	 * @param dataSet
	 *            f[^x[XɏޓeDataSet
	 * @see org.seasar.extension.dataset.impl.SqlWriter#write(DataSet)
	 */
	public void writeDb(DataSet dataSet) {
		DataWriter writer = new SqlWriter(getDataSource());
		writer.write(dataSet);
	}

	/**
	 * <p>
	 * DB烌R[hǂݍ݁ADataTable쐬܂B
	 * </p>
	 * 
	 * @param table
	 *            ǂݍރe[u
	 * @return ǂݍ񂾓e쐬DataTable
	 * @see org.seasar.extension.dataset.impl.SqlTableReader#read()
	 */
	public DataTable readDbByTable(String table) {
		return readDbByTable(table, null);
	}

	/**
	 * <p>
	 * DB烌R[hǂݍ݁ADataTable쐬܂B
	 * </p>
	 * <p>
	 * ǂݍރR[hcondition̏𖞂R[hłB conditionɂ" WHERE "ZbgĂB
	 * </p>
	 * 
	 * @param table
	 *            ǂݍރe[u
	 * @param condition
	 *            (WHERĚ)
	 * @return ǂݍ񂾓e쐬DataTable
	 * @see org.seasar.extension.dataset.impl.SqlTableReader#read()
	 */
	public DataTable readDbByTable(String table, String condition) {
		SqlTableReader reader = new SqlTableReader(getDataSource());
		reader.setTable(table, condition);
		return reader.read();
	}

	/**
	 * <p>
	 * DBSQL̎sʂ擾ADataTable쐬܂B
	 * </p>
	 * <p>
	 * 쐬DataTablẽe[utableNameɂȂ܂B
	 * </p>
	 * 
	 * @param sql
	 *            sSQL
	 * @param tableName
	 *            쐬DataTablẽe[u
	 * @return ǂݏoeDataTable
	 * @see org.seasar.extension.dataset.impl.SqlTableReader#read()
	 */
	public DataTable readDbBySql(String sql, String tableName) {
		SqlTableReader reader = new SqlTableReader(getDataSource());
		reader.setSql(sql, tableName);
		return reader.read();
	}

	/**
	 * <p>
	 * Excelt@Cǂݍ݁ADBɏ݂܂B
	 * </p>
	 * <p>
	 * V[ge[uAsڂJAsڈȍ~f[^ Ƃēǂݍ݂܂B
	 * </p>
	 * 
	 * <p>
	 * pXCLASSPATHŎw肳ĂfBNg[gƂ ݒt@C̐΃pXAt@Ĉ݂w肵܂Bt@C
	 * ݂̂̏ꍇAeXgP[XƓpbP[Wɂ̂Ƃ܂B
	 * </p>
	 * 
	 * @param path
	 *            Excelt@C̃pX
	 * @see org.seasar.extension.dataset.impl.XlsReader#read()
	 * @see org.seasar.extension.dataset.impl.SqlWriter#write(DataSet)
	 */
	public void readXlsWriteDb(String path) {
		writeDb(readXls(path));
	}

	/**
	 * <p>
	 * Excelt@Cǂݍ݁ADBɏ݂܂B
	 * </p>
	 * <p>
	 * V[ge[uAsڂJAsڈȍ~f[^ Ƃēǂݍ݂܂B
	 * </p>
	 * 
	 * <p>
	 * Excel̓eDB̃R[hƂŎL[v̂΁A ̃R[h폜ɏ݂܂B
	 * </p>
	 * 
	 * <p>
	 * pXCLASSPATHŎw肳ĂfBNg[gƂ ݒt@C̐΃pXAt@Ĉ݂w肵܂Bt@C
	 * ݂̂̏ꍇAeXgP[XƓpbP[Wɂ̂Ƃ܂B
	 * </p>
	 * 
	 * @param path
	 *            Excelt@C̃pX
	 * @see org.seasar.extension.dataset.impl.XlsReader#read()
	 * @see org.seasar.extension.dataset.impl.SqlWriter#write(DataSet)
	 */
	public void readXlsReplaceDb(String path) {
		DataSet dataSet = readXls(path);
		deleteDb(dataSet);
		writeDb(dataSet);
	}

	/**
	 * <p>
	 * Excelt@Cǂݍ݁ADBɏ݂܂B
	 * </p>
	 * <p>
	 * V[ge[uAsڂJAsڈȍ~f[^ Ƃēǂݍ݂܂B
	 * </p>
	 * 
	 * <p>
	 * ΏۂƂȂe[ũR[hSč폜ɏ݂܂B
	 * </p>
	 * 
	 * <p>
	 * pXCLASSPATHŎw肳ĂfBNg[gƂ ݒt@C̐΃pXAt@Ĉ݂w肵܂Bt@C
	 * ݂̂̏ꍇAeXgP[XƓpbP[Wɂ̂Ƃ܂B
	 * </p>
	 * 
	 * @see org.seasar.extension.dataset.impl.XlsReader#read()
	 * @see org.seasar.extension.dataset.impl.SqlWriter#write(DataSet)
	 */
	public void readXlsAllReplaceDb(String path) {
		DataSet dataSet = readXls(path);
		for (int i = dataSet.getTableSize() - 1; i >= 0; --i) {
			deleteTable(dataSet.getTable(i).getTableName());
		}
		writeDb(dataSet);
	}

	/**
	 * <p>
	 * DataSetɑΉDB̃R[hǂݍ݁ADataSet쐬܂ B
	 * </p>
	 * 
	 * @param dataSet
	 *            ΏDBɑΉDataSet
	 * @return ŐVԂDataSet
	 * @see org.seasar.extension.dataset.impl.SqlReloadReader#read()
	 */
	public DataSet reload(DataSet dataSet) {
		return new SqlReloadReader(getDataSource(), dataSet).read();
	}

	/**
	 * <p>
	 * DataTableɑΉDB̃R[hǂݍ݁ADataTable쐬 ܂B
	 * </p>
	 * 
	 * @param table
	 *            ΏDBɑΉDataTable
	 * @return ŐVԂDataTable
	 * @see org.seasar.extension.dataset.impl.SqlReloadTableReader#read()
	 */
	public DataTable reload(DataTable table) {
		return new SqlReloadTableReader(getDataSource(), table).read();
	}

	/**
	 * <p>
	 * DataSetɑΉDB̃R[h폜܂B
	 * </p>
	 * 
	 * @param dataSet
	 *            ΏDBɑΉDataSet
	 * @see org.seasar.extension.dataset.impl.SqlDeleteTableWriter#write(DataTable)
	 */
	public void deleteDb(DataSet dataSet) {
		SqlDeleteTableWriter writer = new SqlDeleteTableWriter(getDataSource());
		for (int i = dataSet.getTableSize() - 1; i >= 0; --i) {
			writer.write(dataSet.getTable(i));
		}
	}

	/**
	 * <p>
	 * DBw肷e[ȗSR[h폜܂B
	 * </p>
	 * 
	 * @param tableName
	 *            폜Ώۂ̃e[u
	 */
	public void deleteTable(String tableName) {
		UpdateHandler handler = new BasicUpdateHandler(getDataSource(),
				"DELETE FROM " + tableName);
		handler.execute(null);
	}

	/**
	 * <p>
	 * DataSetmr܂B
	 * </p>
	 * <p>
	 * J̕я͔rɉe܂B <br>
	 * l͑SBigDecimalƂĔr܂B
	 * </p>
	 * 
	 * @param expected
	 *            \l
	 * @param actual
	 *            ےl
	 */
	public void assertEquals(DataSet expected, DataSet actual) {
		assertEquals(null, expected, actual);
	}

	/**
	 * <p>
	 * DataSetmr܂B
	 * </p>
	 * <p>
	 * J̕я͔rɉe܂B <br>
	 * l͑SBigDecimalƂĔr܂B
	 * </p>
	 * 
	 * @param message
	 *            asserts̃bZ[W
	 * @param expected
	 *            \l
	 * @param actual
	 *            ےl
	 */
	public void assertEquals(String message, DataSet expected, DataSet actual) {
		message = message == null ? "" : message;
		assertEquals(message + ":TableSize", expected.getTableSize(), actual
				.getTableSize());
		for (int i = 0; i < expected.getTableSize(); ++i) {
			assertEquals(message, expected.getTable(i), actual.getTable(i));
		}
	}

	/**
	 * <p>
	 * DataTablemr܂B
	 * </p>
	 * <p>
	 * J̕я͔rɉe܂B <br>
	 * l͑SBigDecimalƂĔr܂B
	 * </p>
	 * 
	 * @param expected
	 *            \l
	 * @param actual
	 *            ےl
	 */
	public void assertEquals(DataTable expected, DataTable actual) {
		assertEquals(null, expected, actual);
	}

	/**
	 * </p>
	 * DataTablemr܂B
	 * </p>
	 * <p>
	 * J̕я͔rɉe܂B <br>
	 * l͑SBigDecimalƂĔr܂B
	 * </p>
	 * 
	 * @param message
	 *            asserts̃bZ[W
	 * @param expected
	 *            \l
	 * @param actual
	 *            ےl
	 */
	public void assertEquals(String message, DataTable expected,
			DataTable actual) {

		message = message == null ? "" : message;
		message = message + ":TableName=" + expected.getTableName();
		assertEquals(message + ":RowSize", expected.getRowSize(), actual
				.getRowSize());
		for (int i = 0; i < expected.getRowSize(); ++i) {
			DataRow expectedRow = expected.getRow(i);
			DataRow actualRow = actual.getRow(i);
			List errorMessages = new ArrayList();
			for (int j = 0; j < expected.getColumnSize(); ++j) {
				try {
					String columnName = expected.getColumnName(j);
					Object expectedValue = expectedRow.getValue(columnName);
					ColumnType ct = ColumnTypes.getColumnType(expectedValue);
					Object actualValue = actualRow.getValue(columnName);
					if (!ct.equals(expectedValue, actualValue)) {
						assertEquals(message + ":Row=" + i + ":columnName="
								+ columnName, expectedValue, actualValue);
					}
				} catch (AssertionFailedError e) {
					errorMessages.add(e.getMessage());
				}
			}
			if (!errorMessages.isEmpty()) {
				fail(message + errorMessages);
			}
		}
	}

	/**
	 * <p>
	 * IuWFNgDataSetƔr܂B
	 * </p>
	 * <p>
	 * IuWFNǵABeanAMapABeanListAMapList̂ꂩ łȂ΂Ȃ܂B
	 * </p>
	 * 
	 * </p>
	 * Bean̏ꍇ̓vpeBAMap̏ꍇ̓L[JƂ r܂B <br>
	 * J̕я͔rɉe܂B <br>
	 * l͑SBigDecimalƂĔr܂B
	 * </p>
	 * 
	 * @param expected
	 *            \l
	 * @param actual
	 *            ےl
	 */
	public void assertEquals(DataSet expected, Object actual) {
		assertEquals(null, expected, actual);
	}

	/**
	 * <p>
	 * IuWFNgDataSetƔr܂B
	 * </p>
	 * <p>
	 * IuWFNǵABeanAMapABeanListAMapList̂ꂩ łȂ΂Ȃ܂B
	 * </p>
	 * 
	 * <p>
	 * Bean̏ꍇ̓vpeBAMap̏ꍇ̓L[JƂ r܂B <br>
	 * J̕я͔rɉe܂B <br>
	 * l͑SBigDecimalƂĔr܂B
	 * </p>
	 * 
	 * @param message
	 *            asserts̃bZ[W
	 * @param expected
	 *            \l
	 * @param actual
	 *            ےl
	 */
	public void assertEquals(String message, DataSet expected, Object actual) {
		if (expected == null || actual == null) {
			Assert.assertEquals(message, expected, actual);
			return;
		}
		if (actual instanceof List) {
			List actualList = (List) actual;
			Assert.assertFalse(actualList.isEmpty());
			Object actualItem = actualList.get(0);
			if (actualItem instanceof Map) {
				assertMapListEquals(message, expected, actualList);
			} else {
				assertBeanListEquals(message, expected, actualList);
			}
		} else if (actual instanceof Object[]) {
			assertEquals(message, expected, Arrays.asList((Object[]) actual));
		} else {
			if (actual instanceof Map) {
				assertMapEquals(message, expected, (Map) actual);
			} else {
				assertBeanEquals(message, expected, actual);
			}
		}
	}

	/**
	 * <p>
	 * MapDataSetƔr܂B
	 * </p>
	 * <p>
	 * Map̃L[JƂĔr܂B <br>
	 * J̕я͔rɉe܂B <br>
	 * l͑SBigDecimalƂĔr܂B
	 * </p>
	 * 
	 * @param message
	 *            asserts̃bZ[W
	 * @param expected
	 *            \l
	 * @param map
	 *            ےl
	 */
	protected void assertMapEquals(String message, DataSet expected, Map map) {

		MapReader reader = new MapReader(map);
		assertEquals(message, expected, reader.read());
	}

	/**
	 * <p>
	 * MapListDataSetƔr܂B
	 * </p>
	 * <p>
	 * Map̃L[JƂĔr܂B <br>
	 * J̕я͔rɉe܂B <br>
	 * l͑SBigDecimalƂĔr܂B
	 * </p>
	 * 
	 * @param message
	 *            asserts̃bZ[W
	 * @param expected
	 *            \l
	 * @param list
	 *            ےl
	 */
	protected void assertMapListEquals(String message, DataSet expected,
			List list) {

		MapListReader reader = new MapListReader(list);
		assertEquals(message, expected, reader.read());
	}

	/**
	 * <p>
	 * BeanDataSetƔr܂B
	 * </p>
	 * <p>
	 * BeañvpeBJƂĔr܂B <br>
	 * J̕я͔rɉe܂B <br>
	 * l͑SBigDecimalƂĔr܂B
	 * </p>
	 * 
	 * @param message
	 *            asserts̃bZ[W
	 * @param expected
	 *            \l
	 * @param bean
	 *            ےl
	 */
	protected void assertBeanEquals(String message, DataSet expected,
			Object bean) {

		BeanReader reader = new BeanReader(bean);
		assertEquals(message, expected, reader.read());
	}

	/**
	 * <p>
	 * BeanListDataSetƔr܂B
	 * </p>
	 * <p>
	 * BeañvpeBJƂĔr܂B <br>
	 * J̕я͔rɉe܂B <br>
	 * l͑SBigDecimalƂĔr܂B
	 * </p>
	 * 
	 * @param message
	 *            asserts̃bZ[W
	 * @param expected
	 *            \l
	 * @param list
	 *            ےl
	 */
	protected void assertBeanListEquals(String message, DataSet expected,
			List list) {

		BeanListReader reader = new BeanListReader(list);
		assertEquals(message, expected, reader.read());
	}

	/**
	 * @see junit.framework.TestCase#runBare()
	 */
	public void runBare() throws Throwable {
		setUpContainer();
		setUp();
		try {
			setUpForEachTestMethod();
			try {
				container_.init();
				try {
					setupDataSource();
					try {
						setUpAfterContainerInit();
						bindFields();
						setUpAfterBindFields();
						try {
							runTestTx();
						} finally {
							tearDownBeforeUnbindFields();
							unbindFields();
						}
						tearDownBeforeContainerDestroy();
					} finally {
						tearDownDataSource();
					}
				} finally {
					tearDownContainer();
				}
			} finally {
				tearDownForEachTestMethod();
			}

		} finally {
			for (int i = 0; i < 5; ++i) {
				System.runFinalization();
				System.gc();
			}
			tearDown();
		}
	}

	/**
	 * <p>
	 * ReiZbgAbv郁\bhłB
	 * </p>
	 * <p>
	 * KvȏꍇɃI[o[ChĂB
	 * </p>
	 * 
	 * @throws Throwable
	 */
	protected void setUpContainer() throws Throwable {
		container_ = new S2ContainerImpl();
		servletContext_ = new MockServletContextImpl("s2jsf-example");
		request_ = servletContext_.createRequest("/hello.html");
		response_ = new MockHttpServletResponseImpl(request_);
		servletConfig_ = new MockServletConfigImpl();
		servletConfig_.setServletContext(servletContext_);
		servlet_ = new MockServlet();
		servlet_.init(servletConfig_);
		container_.setServletContext(servletContext_);
		container_.setRequest(request_);
		container_.setResponse(response_);
		SingletonS2ContainerFactory.setContainer(container_);
	}

	protected void tearDownContainer() throws Throwable {
		container_.destroy();
		SingletonS2ContainerFactory.setContainer(null);
		container_ = null;
		servletContext_ = null;
		request_ = null;
		response_ = null;
		servletConfig_ = null;
		servlet_ = null;
	}

	/**
	 * <p>
	 * ReiɎsZbgAbv\bhłB
	 * </p>
	 * <p>
	 * KvȏꍇɃI[o[ChĂB
	 * </p>
	 * 
	 * @throws Throwable
	 */
	protected void setUpAfterContainerInit() throws Throwable {
	}

	/**
	 * <p>
	 * tB[hݒ肳ꂽɎsZbgAbv\bhłB
	 * </p>
	 * <p>
	 * KvȏꍇɃI[o[ChĂB
	 * </p>
	 * 
	 * @throws Throwable
	 */
	protected void setUpAfterBindFields() throws Throwable {
	}

	/**
	 * <p>
	 * tB[h̐ݒ肪OɎs鏈I\bhłB
	 * </p>
	 * <p>
	 * KvȏꍇɃI[o[ChĂB
	 * </p>
	 * 
	 * @throws Throwable
	 */
	protected void tearDownBeforeUnbindFields() throws Throwable {
	}

	/**
	 * <p>
	 * setup() ɎseXg\bhƂ̃ZbgAbv \bhłB
	 * </p>
	 * <p>
	 * testXxx() Ƃ\bh̏ꍇAsetUpXxx() ƂO ZbgAbv\bh쐬ĂƁAIɎs܂B
	 * </p>
	 * 
	 * @throws Throwable
	 */
	protected void setUpForEachTestMethod() throws Throwable {
		String targetName = getTargetName();
		if (targetName.length() > 0) {
			invoke("setUp" + targetName);
		}
	}

	/**
	 * <p>
	 * ReiIOɎsI\bhłB
	 * </p>
	 * <p>
	 * KvȏꍇɃI[o[ChĂB
	 * </p>
	 * 
	 * @throws Throwable
	 */
	protected void tearDownBeforeContainerDestroy() throws Throwable {
	}

	/**
	 * <p>
	 * tearDown() OɎseXg\bhƂ̏I\bh łB
	 * </p>
	 * <p>
	 * testXxx() Ƃ\bh̏ꍇAtearDownXxx() ƂO I\bh쐬ĂƁAIɎs܂B
	 * </p>
	 * 
	 * @throws Throwable
	 */
	protected void tearDownForEachTestMethod() throws Throwable {
		String targetName = getTargetName();
		if (targetName.length() > 0) {
			invoke("tearDown" + getTargetName());
		}
	}

	protected Servlet getServlet() {
		return servlet_;
	}

	protected void setServlet(Servlet servlet) {
		servlet_ = servlet;
	}

	protected MockServletConfig getServletConfig() {
		return servletConfig_;
	}

	protected void setServletConfig(MockServletConfig servletConfig) {
		servletConfig_ = servletConfig;
	}

	protected MockServletContext getServletContext() {
		return servletContext_;
	}

	protected void setServletContext(MockServletContext servletContext) {
		servletContext_ = servletContext;
	}

	protected MockHttpServletRequest getRequest() {
		return request_;
	}

	protected void setRequest(MockHttpServletRequest request) {
		request_ = request;
	}

	protected MockHttpServletResponse getResponse() {
		return response_;
	}

	protected void setResponse(MockHttpServletResponse response) {
		response_ = response;
	}

	private String getTargetName() {
		return getName().substring(4);
	}

	private void invoke(String methodName) throws Throwable {
		try {
			Method method = ClassUtil.getMethod(getClass(), methodName, null);
			MethodUtil.invoke(method, this, null);
		} catch (NoSuchMethodRuntimeException ignore) {
		}
	}

	private void bindFields() throws Throwable {
		bindedFields_ = new ArrayList();
		for (Class clazz = getClass(); clazz != S2TestCase.class
				&& clazz != null; clazz = clazz.getSuperclass()) {

			Field[] fields = clazz.getDeclaredFields();
			for (int i = 0; i < fields.length; ++i) {
				bindField(fields[i]);
			}
		}
	}

	private void bindField(Field field) {
		if (isAutoBindable(field)) {
			field.setAccessible(true);
			if (FieldUtil.get(field, this) != null) {
				return;
			}
			String name = normalizeName(field.getName());
			Object component = null;
			if (getContainer().hasComponentDef(name)) {
				Class componentClass = getComponentDef(name)
						.getComponentClass();
				if (componentClass == null) {
					component = getComponent(name);
					if (component != null) {
						componentClass = component.getClass();
					}
				}
				if (componentClass != null
						&& field.getType().isAssignableFrom(componentClass)) {
					if (component == null) {
						component = getComponent(name);
					}
				} else {
					component = null;
				}
			}
			if (component == null
					&& getContainer().hasComponentDef(field.getType())) {
				component = getComponent(field.getType());
			}
			if (component != null) {
				FieldUtil.set(field, this, component);
				bindedFields_.add(field);
			}
		}
	}

	private String normalizeName(String name) {
		return StringUtil.replace(name, "_", "");
	}

	private boolean isAutoBindable(Field field) {
		int modifiers = field.getModifiers();
		return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers)
				&& !field.getType().isPrimitive();
	}

	private void unbindFields() {
		for (int i = 0; i < bindedFields_.size(); ++i) {
			Field field = (Field) bindedFields_.get(i);
			try {
				field.set(this, null);
			} catch (IllegalArgumentException e) {
				System.err.println(e);
			} catch (IllegalAccessException e) {
				System.err.println(e);
			}
		}
	}

	private void runTestTx() throws Throwable {
		TransactionManager tm = null;
		if (needTransaction()) {
			try {
				tm = (TransactionManager) getComponent(TransactionManager.class);
				tm.begin();
			} catch (Throwable t) {
				System.err.println(t);
			}
		}
		try {
			runTest();
		} finally {
			if (tm != null) {
				tm.rollback();
			}
		}
	}

	private boolean needTransaction() {
		return getName().endsWith("Tx");
	}

	private void setupDataSource() {
		try {
			if (container_.hasComponentDef(DATASOURCE_NAME)) {
				dataSource_ = (DataSource) container_
						.getComponent(DATASOURCE_NAME);
			} else if (container_.hasComponentDef(DataSource.class)) {
				dataSource_ = (DataSource) container_
						.getComponent(DataSource.class);
			}
		} catch (Throwable t) {
			System.err.println(t);
		}
	}

	private void tearDownDataSource() {
		dbMetaData_ = null;
		if (connection_ != null) {
			ConnectionUtil.close(connection_);
			connection_ = null;
		}
		dataSource_ = null;
	}
}