/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.Rule;
import com.tonicsystems.jarjar.Rules;
import com.tonicsystems.jarjar.StringTransformer;
import com.tonicsystems.jarjar.Wildcard;
import com.tonicsystems.jarjar.asm.Attribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class RulesImpl
implements Rules {
    private static final String RESOURCE_SUFFIX = "RESOURCE";
    private Wildcard[] wildcards;
    private HashMap cache = new HashMap();
    private StringTransformer def;
    private boolean verbose;

    public RulesImpl(List ruleList, boolean verbose) {
        this.verbose = verbose;
        this.wildcards = new Wildcard[ruleList.size()];
        int i = 0;
        Iterator it = ruleList.iterator();
        while (it.hasNext()) {
            Rule rule = (Rule)it.next();
            this.wildcards[i++] = new Wildcard(rule.getPattern(), rule.getResult());
        }
        this.def = new StringTransformer(){

            public String transform(String value, String className) {
                String oldValue = value;
                if ((value = RulesImpl.this.fixPath(value)).equals(oldValue)) {
                    for (int i = 0; i < RulesImpl.this.wildcards.length; ++i) {
                        value = RulesImpl.this.wildcards[i].replaceAll(value, 1);
                        value = RulesImpl.this.wildcards[i].replaceAll(value, 2);
                    }
                }
                return value;
            }
        };
    }

    public String fixPath(String path) {
        String end;
        int slash = path.lastIndexOf(47);
        if (slash < 0) {
            end = path;
            path = RESOURCE_SUFFIX;
        } else {
            end = path.substring(slash + 1);
            path = path.substring(0, slash + 1) + RESOURCE_SUFFIX;
        }
        path = this.fixName(path);
        path = path.substring(0, path.length() - RESOURCE_SUFFIX.length()) + end;
        return path;
    }

    public String fixDesc(String desc) {
        if (desc.charAt(desc.length() - 1) != ';') {
            return desc;
        }
        String value = (String)this.cache.get(desc);
        if (value == null) {
            value = desc;
            for (int i = 0; i < this.wildcards.length; ++i) {
                String oldValue = value;
                if (!(value = this.wildcards[i].replace(value, 0)).equals(oldValue)) break;
            }
            this.cache.put(desc, value);
        }
        return value;
    }

    public String fixName(String name) {
        if (name == null) {
            return null;
        }
        String desc = this.fixDesc("L" + name + ";");
        return desc.substring(1, desc.length() - 1);
    }

    public String fixMethodDesc(String desc) {
        String value = (String)this.cache.get(desc);
        if (value == null) {
            if (desc.indexOf(76) < 0) {
                value = desc;
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append('(');
                int end = desc.lastIndexOf(41);
                block0: for (int i = 1; i < end; ++i) {
                    char c = desc.charAt(i);
                    if (c == 'L') {
                        for (int j = i + 1; j < end; ++j) {
                            if (desc.charAt(j) != ';') continue;
                            sb.append(this.fixDesc(desc.substring(i, j + 1)));
                            i = j;
                            continue block0;
                        }
                        continue;
                    }
                    sb.append(c);
                }
                sb.append(')');
                sb.append(this.fixDesc(desc.substring(end + 1)));
                value = sb.toString();
            }
            this.cache.put(desc, value);
        }
        return value;
    }

    public String fixString(String className, String value) {
        String newValue = this.def.transform(value, className);
        if (this.verbose && !newValue.equals(value)) {
            System.err.println("Changed " + className + " \"" + value + "\" -> \"" + newValue + "\"");
        }
        return newValue;
    }

    public Attribute fixAttribute(Attribute attrs) {
        return attrs;
    }
}

