/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.impl;

import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.DataColumn;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.impl.DataColumnImpl;
import org.seasar.extension.dataset.impl.DataRowImpl;
import org.seasar.extension.dataset.states.RowStates;
import org.seasar.extension.dataset.types.ColumnTypes;
import org.seasar.extension.jdbc.ColumnNotFoundRuntimeException;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.ArrayMap;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.DatabaseMetaDataUtil;
import org.seasar.framework.util.StringUtil;

public class DataTableImpl
implements DataTable {
    private String tableName_;
    private List rows_ = new ArrayList();
    private List removedRows_ = new ArrayList();
    private ArrayMap columns_ = new CaseInsensitiveMap();
    private boolean hasMetaData_ = false;

    public DataTableImpl(String tableName) {
        this.setTableName(tableName);
    }

    public String getTableName() {
        return this.tableName_;
    }

    public void setTableName(String tableName) {
        this.tableName_ = tableName;
    }

    public int getRowSize() {
        return this.rows_.size();
    }

    public DataRow getRow(int index) {
        return (DataRow)this.rows_.get(index);
    }

    public DataRow addRow() {
        DataRowImpl row = new DataRowImpl(this);
        this.rows_.add(row);
        row.setState(RowStates.CREATED);
        return row;
    }

    public int getRemovedRowSize() {
        return this.removedRows_.size();
    }

    public DataRow getRemovedRow(int index) {
        return (DataRow)this.removedRows_.get(index);
    }

    public DataRow[] removeRows() {
        int i = 0;
        while (i < this.rows_.size()) {
            DataRow row = this.getRow(i);
            if (row.getState().equals(RowStates.REMOVED)) {
                this.removedRows_.add(row);
                this.rows_.remove(i);
                continue;
            }
            ++i;
        }
        return this.removedRows_.toArray(new DataRow[this.removedRows_.size()]);
    }

    public int getColumnSize() {
        return this.columns_.size();
    }

    public DataColumn getColumn(int index) {
        return (DataColumn)this.columns_.get(index);
    }

    public DataColumn getColumn(String columnName) {
        DataColumn column = this.getColumn0(columnName);
        if (column == null) {
            throw new ColumnNotFoundRuntimeException(this.tableName_, columnName);
        }
        return column;
    }

    private DataColumn getColumn0(String columnName) {
        String name;
        DataColumn column = (DataColumn)this.columns_.get((Object)columnName);
        if (column == null && (column = (DataColumn)this.columns_.get((Object)(name = StringUtil.replace((String)columnName, (String)"_", (String)"")))) == null) {
            for (int i = 0; i < this.columns_.size(); ++i) {
                String key = (String)this.columns_.getKey(i);
                String key2 = StringUtil.replace((String)key, (String)"_", (String)"");
                if (!key2.equalsIgnoreCase(name)) continue;
                column = (DataColumn)this.columns_.get(i);
                break;
            }
        }
        return column;
    }

    public boolean hasColumn(String columnName) {
        return this.getColumn0(columnName) != null;
    }

    public String getColumnName(int index) {
        return this.getColumn(index).getColumnName();
    }

    public ColumnType getColumnType(int index) {
        return this.getColumn(index).getColumnType();
    }

    public ColumnType getColumnType(String columnName) {
        return this.getColumn(columnName).getColumnType();
    }

    public DataColumn addColumn(String columnName) {
        return this.addColumn(columnName, ColumnTypes.OBJECT);
    }

    public DataColumn addColumn(String columnName, ColumnType columnType) {
        DataColumnImpl column = new DataColumnImpl(columnName, columnType, this.columns_.size());
        this.columns_.put((Object)columnName, (Object)column);
        return column;
    }

    public boolean hasMetaData() {
        return this.hasMetaData_;
    }

    public void setupMetaData(DatabaseMetaData dbMetaData) {
        Set primaryKeySet = DatabaseMetaDataUtil.getPrimaryKeySet((DatabaseMetaData)dbMetaData, (String)this.tableName_);
        Set columnSet = DatabaseMetaDataUtil.getColumnSet((DatabaseMetaData)dbMetaData, (String)this.tableName_);
        for (int i = 0; i < this.getColumnSize(); ++i) {
            DataColumn column = this.getColumn(i);
            if (primaryKeySet.contains(column.getColumnName())) {
                column.setPrimaryKey(true);
            } else {
                column.setPrimaryKey(false);
            }
            if (columnSet.contains(column.getColumnName())) {
                column.setWritable(true);
                continue;
            }
            column.setWritable(false);
        }
        this.hasMetaData_ = true;
    }

    public void setupColumns(Class beanClass) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)beanClass);
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            this.addColumn(pd.getPropertyName(), ColumnTypes.getColumnType(pd.getPropertyType()));
        }
    }

    public void copyFrom(Object source) {
        if (source instanceof List) {
            this.copyFromList((List)source);
        } else {
            this.copyFromBeanOrMap(source);
        }
    }

    private void copyFromList(List source) {
        for (int i = 0; i < source.size(); ++i) {
            DataRow row = this.addRow();
            row.copyFrom(source.get(i));
            row.setState(RowStates.UNCHANGED);
        }
    }

    private void copyFromBeanOrMap(Object source) {
        DataRow row = this.addRow();
        row.copyFrom(source);
        row.setState(RowStates.UNCHANGED);
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer(100);
        buf.append(this.tableName_);
        buf.append(":");
        for (i = 0; i < this.columns_.size(); ++i) {
            buf.append(this.getColumnName(i));
            buf.append(", ");
        }
        buf.setLength(buf.length() - 2);
        buf.append("\n");
        for (i = 0; i < this.rows_.size(); ++i) {
            buf.append(this.getRow(i) + "\n");
        }
        buf.setLength(buf.length() - 1);
        return buf.toString();
    }

    public boolean equals(Object o) {
        int i;
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTable)) {
            return false;
        }
        DataTable other = (DataTable)o;
        if (this.getRowSize() != other.getRowSize()) {
            return false;
        }
        for (i = 0; i < this.getRowSize(); ++i) {
            if (this.getRow(i).equals(other.getRow(i))) continue;
            return false;
        }
        if (this.getRemovedRowSize() != other.getRemovedRowSize()) {
            return false;
        }
        for (i = 0; i < this.getRemovedRowSize(); ++i) {
            if (this.getRemovedRow(i).equals(other.getRemovedRow(i))) continue;
            return false;
        }
        return true;
    }
}

