/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.javassist;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.ListIterator;
import javassist.ClassPool;
import javassist.CtClass;
import org.seasar.framework.aop.javassist.AbstractGenerator;
import org.seasar.framework.aop.javassist.TryBlockSupport;

public class EnhancedClassGenerator
extends AbstractGenerator {
    protected final Class targetClass;
    protected final String enhancedClassName;
    protected CtClass enhancedClass;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$Error;

    public EnhancedClassGenerator(ClassPool classPool, Class targetClass, String enhancedClassName) {
        super(classPool);
        this.targetClass = targetClass;
        this.enhancedClassName = enhancedClassName;
        this.setupClass();
        this.setupInterface();
        this.setupConstructor();
    }

    public void createTargetMethod(Method method, String methodInvocationClassName) {
        this.createMethod(this.enhancedClass, method, EnhancedClassGenerator.createTargetMethodSource(method, methodInvocationClassName));
    }

    public void createInvokeSuperMethod(Method method, String invokeSuperMethodName) {
        this.createMethod(this.enhancedClass, method.getModifiers(), method.getReturnType(), invokeSuperMethodName, method.getParameterTypes(), method.getExceptionTypes(), EnhancedClassGenerator.createInvokeSuperMethodSource(method));
    }

    public Class toClass(ClassLoader classLoader) {
        Class clazz = this.toClass(classLoader, this.enhancedClass);
        this.enhancedClass.detach();
        this.enhancedClass = null;
        return clazz;
    }

    public void setupClass() {
        Class clazz = this.targetClass.isInterface() ? (class$java$lang$Object == null ? (class$java$lang$Object = EnhancedClassGenerator.class$("java.lang.Object")) : class$java$lang$Object) : this.targetClass;
        Class superClass = clazz;
        this.enhancedClass = this.createCtClass(this.enhancedClassName, superClass);
    }

    public void setupInterface() {
        if (this.targetClass.isInterface()) {
            this.setInterface(this.enhancedClass, this.targetClass);
        }
    }

    public void setupConstructor() {
        Constructor<?>[] constructors = this.targetClass.getDeclaredConstructors();
        if (constructors.length == 0) {
            this.createDefaultConstructor(this.enhancedClass);
        } else {
            for (int i = 0; i < constructors.length; ++i) {
                int modifier = constructors[i].getModifiers();
                Package pkg = this.targetClass.getPackage();
                if (!Modifier.isPublic(modifier) && !Modifier.isProtected(modifier) && (Modifier.isPrivate(modifier) || this.targetClass.getName().startsWith("java.") || pkg != null && pkg.isSealed())) continue;
                this.createConstructor(this.enhancedClass, constructors[i]);
            }
        }
    }

    public static String createTargetMethodSource(Method method, String methodInvocationClassName) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("Object result = new ").append(methodInvocationClassName).append("(this, $args).proceed();");
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            buf.append("return;");
        } else if (returnType.isPrimitive()) {
            buf.append("return ($r) ((result == null) ? ");
            if (returnType.equals(Boolean.TYPE)) {
                buf.append("false : ");
            } else {
                buf.append("0 : ");
            }
            buf.append(EnhancedClassGenerator.fromObject(returnType, "result")).append(");");
        } else {
            buf.append("return ($r) result;");
        }
        String code = new String(buf);
        Class[] exceptionTypes = EnhancedClassGenerator.normalizeExceptionTypes(method.getExceptionTypes());
        if (exceptionTypes.length != 1 || !exceptionTypes[0].equals(class$java$lang$Throwable == null ? (class$java$lang$Throwable = EnhancedClassGenerator.class$("java.lang.Throwable")) : class$java$lang$Throwable)) {
            code = EnhancedClassGenerator.aroundTryCatchBlock(exceptionTypes, code);
        }
        return "{" + code + "}";
    }

    public static String createInvokeSuperMethodSource(Method method) {
        return "{return ($r) super." + method.getName() + "($$);" + "}";
    }

    public static Class[] normalizeExceptionTypes(Class[] exceptionTypes) {
        LinkedList<Class> list = new LinkedList<Class>();
        block0: for (int i = 0; i < exceptionTypes.length; ++i) {
            Class currentException = exceptionTypes[i];
            ListIterator it = list.listIterator();
            while (it.hasNext()) {
                Class comparisonException = (Class)it.next();
                if (comparisonException.isAssignableFrom(currentException)) continue block0;
                if (!currentException.isAssignableFrom(comparisonException)) continue;
                it.remove();
            }
            list.add(currentException);
        }
        return list.toArray(new Class[list.size()]);
    }

    public static String aroundTryCatchBlock(Class[] exceptionTypes, String code) {
        TryBlockSupport tryBlock = new TryBlockSupport(code);
        boolean needRuntimeException = true;
        boolean needError = true;
        for (int i = 0; i < exceptionTypes.length; ++i) {
            Class exceptionType = exceptionTypes[i];
            tryBlock.addCatchBlock(exceptionType, "throw e;");
            if (exceptionType.equals(class$java$lang$RuntimeException == null ? EnhancedClassGenerator.class$("java.lang.RuntimeException") : class$java$lang$RuntimeException)) {
                needRuntimeException = false;
            }
            if (!exceptionType.equals(class$java$lang$Error == null ? EnhancedClassGenerator.class$("java.lang.Error") : class$java$lang$Error)) continue;
            needError = false;
        }
        if (needRuntimeException) {
            tryBlock.addCatchBlock(class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = EnhancedClassGenerator.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException, "throw e;");
        }
        if (needError) {
            tryBlock.addCatchBlock(class$java$lang$Error == null ? (class$java$lang$Error = EnhancedClassGenerator.class$("java.lang.Error")) : class$java$lang$Error, "throw e;");
        }
        tryBlock.addCatchBlock(class$java$lang$Throwable == null ? (class$java$lang$Throwable = EnhancedClassGenerator.class$("java.lang.Throwable")) : class$java$lang$Throwable, "throw new java.lang.reflect.UndeclaredThrowableException(e);");
        return tryBlock.getSourceCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

