package test.org.seasar.hibernate3.impl;

import java.util.List;

import org.hibernate.Session;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;

import org.seasar.hibernate3.impl.S2SessionFactoryImpl;

public class S2SessionFactoryImplTest extends S2TestCase {

	private static final String CONFIG_PATH =
		"test/org/seasar/hibernate3/impl/hibernate3.cfg.xml";
	private S2SessionFactoryImpl s2SessionFactory_;
	
	/**
	 * Constructor for S2SessionFactoryImplTest.
	 * @param arg0
	 */
	public S2SessionFactoryImplTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(S2SessionFactoryImplTest.class);
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		include("j2ee.dicon");
		ComponentDef cd = new ComponentDefImpl(S2SessionFactoryImpl.class, "s2SessionFactory");
		cd.addPropertyDef(new PropertyDefImpl("configPath", CONFIG_PATH));
		register(cd);
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetSessionFactory() {
		assertNotNull("1", s2SessionFactory_.getSessionFactory());
	}
	
	public void testGetSession() throws Exception {
		Session session = s2SessionFactory_.getSession();
		try {
			assertNotNull("1", session);
			assertEquals("2", 0, s2SessionFactory_.getTxSessionSize()); 
		} finally {
			session.close();
		}
		
	}
	
	public void testGetSessionTx() throws Exception {
		Session session = s2SessionFactory_.getSession();
		Session session2 = s2SessionFactory_.getSession();
		assertSame("1", session, session2);
		
		List result = session.createQuery("from Emp where empno = ?").setInteger(0, 7900).list();
		assertEquals("2", 1, result.size());
		Emp emp = (Emp) result.get(0);
		emp.setEname("JAMES");
	}
}