package org.seasar.hibernate3.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

/**
 * @author koichik
 */
public class DistinctIterator implements Iterator {
    private Iterator iterator;
    private Object prev;
    private Object next;

    public DistinctIterator(final Iterator iterator) {
        this.iterator = iterator;
    }

    public boolean hasNext() {
        if (prev == null) {
            return iterator.hasNext();
        }
        if (next != null) {
            return true;
        }
        while (iterator.hasNext()) {
            next = iterator.next();
            if (next != prev) {
                return true;
            }
        }
        next = null;
        return false;
    }

    public Object next() {
        if (prev == null) {
            prev = iterator.next();
            return prev;
        }
        if (next != null || hasNext()) {
            prev = next;
            next = null;
            return prev;
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}
