package org.seasar.hibernate3.dao.interceptors;

import java.lang.reflect.Method;

import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.util.MethodUtil;
import org.seasar.hibernate3.dao.HibernateCommand;
import org.seasar.hibernate3.dao.HibernateDaoMetaData;
import org.seasar.hibernate3.dao.HibernateDaoMetaDataFactory;

/**
 * @author kenichi_okazaki
 */
public class S2HibernateDaoInterceptor extends AbstractInterceptor {

    HibernateDaoMetaDataFactory hibernateDaoMetaDataFactory_;

    public S2HibernateDaoInterceptor(HibernateDaoMetaDataFactory hibernateDaoMetaDataFactory) {
        hibernateDaoMetaDataFactory_ = hibernateDaoMetaDataFactory;
    }

    /**
     * @see org.aopalliance.intercept.MethodInterceptor#invoke(org.aopalliance.intercept.MethodInvocation)
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (!MethodUtil.isAbstract(method)) {
            return invocation.proceed();
        }
        Class daoClass = getTargetClass(invocation);
        HibernateDaoMetaData dmd = hibernateDaoMetaDataFactory_.getDaoMetaData(daoClass);
        HibernateCommand cmd = dmd.getHibernateCommand(method.getName());

        return cmd.execute(invocation.getArguments());
    }
}
