package org.seasar.hibernate3.dao.impl;

import java.io.Serializable;
import java.lang.reflect.Method;

import org.hibernate.LockMode;
import org.hibernate.Session;
import org.seasar.hibernate3.S2SessionFactory;

/**
 * @author kenichi_okazaki
 */
public class LoadCommand extends AbstractHibernateCommand{
	private Class beanClass_;
	private Method method_;
	private LockMode lockMode_;
	
	public LoadCommand(S2SessionFactory s2sessionFactory,Class beanClass, Method method) {
		super(s2sessionFactory);
		beanClass_ = beanClass;
		method_ = method;
	}

	/* ( Javadoc)
	 * @see org.srasar.hibernate.dao.HibernateCommand#execute(org.seasar.hibernate.S2Session, java.lang.Object[])
	 */
	public Object execute( Object[] args) {
		Session session = getSession();
		if(lockMode_== null ){
			return session.get(beanClass_,(Serializable) args[0]);
		}else{
			return session.get(beanClass_,(Serializable) args[0],lockMode_ );
		}
	}
	/**
	 * @param lockMode The lockMode to set.
	 */
	public void setLockMode(String lockMode) {
		final String NONE="NONE";
		final String READ="READ";
		final String UPGRADE="UPGRADE";
		
		if(lockMode.equals( NONE )){
			lockMode_ = LockMode.NONE;	
			
		}else if( lockMode.equals( READ )){
			lockMode_ = LockMode.READ;	
			
		}else if(lockMode.equals(UPGRADE)){
			lockMode_ = LockMode.UPGRADE;	

		}else{
			lockMode_ = null;
		}
	}
}
