package org.seasar.hibernate3.dao.impl;

import java.util.List;
import java.lang.reflect.Method;


import org.hibernate.Query;
import org.seasar.hibernate3.S2SessionFactory;

/**
 * @author kenichi_okazaki
 *
 */
public abstract class AbstractHQLHibernateCommand extends AbstractQueryHibernateCommand {

	/**
	 * @param s2sessionFactory
	 */
	public AbstractHQLHibernateCommand(S2SessionFactory s2sessionFactory,Class beanClass,Method method) {
		super(s2sessionFactory,beanClass,method);

	}

	protected List queryExecute(Query query,Object[] args ){
		String[] argNames ;
		ArgsMetaData argsMeta = getArgsMeta();
		argNames = argsMeta.getArgNames();
			
			
				for (int i = 0; i < argsMeta.getArgsCount(); ++i) {
				
				Object value = argsMeta.getValue( args, i);
				String name = argsMeta.getArgument(i).getFieldName();
				if (value != null) {
					if (name.equals("firstResult") == true) {
						query.setFirstResult(((Integer) value).intValue());
				
					} else if (name.equals("maxResults") == true) {
						query.setMaxResults(((Integer) value).intValue());

					} else {
						if( value instanceof List){
							query.setParameterList(name, (List)value);

						}else{
							query.setParameter(name, value);
						}
					}
				}
			}

			return query.list();

	}
	
	protected Object getReturnObject(Method method,List ret){
		if (method.getReturnType().isAssignableFrom(List.class)) {
			return ret;
		} else  {
			if(ret == null || ret.size() == 0){
				return null;
			} else {
				return ret.get(0);
			}
		}
	}
}
