package org.seasar.hibernate3.dao.criteria;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.criterion.Expression;

/**
 * @author kenichi_okazaki
 */
public class InCriteriaCommand extends abstractCriteriaCommand {

    /**
     * @param fieldName
     * @param dtoFieldName
     */
    public InCriteriaCommand(String fieldName, String dtoFieldName) {
        super(fieldName, dtoFieldName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.seasar.hibernate.dao.criteria.CriteriaCommand#getCriteria(net.sf.hibernate.Criteria,
     *      java.lang.Object)
     */
    public Criteria getCriteria(Criteria criteria, Object value) {
		if(value instanceof List){
            return criteria.add(Expression.in(fieldName_, (List) value));
        }
        return criteria.add(Expression.in(fieldName_, (Object[]) value));
    }
}
