package org.seasar.hibernate3.dao.criteria;

import org.hibernate.Criteria;
import org.hibernate.criterion.Expression;

/**
 * @author kenichi_okazaki
 */
public class GtCriteriaCommand extends abstractCriteriaCommand {

    /**
     * @param fieldName
     * @param dtoFieldName
     */
    public GtCriteriaCommand(String fieldName, String dtoFieldName) {
        super(fieldName, dtoFieldName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.seasar.hibernate.dao.criteria.CriteriaCommand#getCriteria(net.sf.hibernate.Criteria,
     *      java.lang.Object)
     */
    public Criteria getCriteria(Criteria criteria, Object value) {
        return criteria.add(Expression.gt(fieldName_, value));
    }
}
