package org.seasar.hibernate3.dao.criteria;

import org.hibernate.Criteria;

/**
 * @author kenichi_okazaki
 */
public class FirstResultCriteriaCommand extends abstractCriteriaCommand {

    /**
     * @param fieldName
     * @param dtoFieldName
     */
    public FirstResultCriteriaCommand(String fieldName, String dtoFieldName) {
        super(fieldName, dtoFieldName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.seasar.hibernate.dao.criteria.CriteriaCommand#getCriteria(net.sf.hibernate.Criteria,
     *      java.lang.Object)
     */
    public Criteria getCriteria(Criteria criteria, Object value) {
        return criteria.setFirstResult(((Integer) value).intValue());
    }
}
