package examples.hibernate3.client;

import java.util.List;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;

import examples.hibernate.dao.EmployeeAutoDao;
import examples.hibernate.entity.Employee;

public class EmployeeAutoDaoSimpleDtoClient {

	private static final String PATH = 
				"examples/hibernate3/client/EmployeeAutoDao.dicon";

	public static void main(String[] args) {
		S2Container container = S2ContainerFactory.create(PATH);/* 菇1 */
		container.init();
		try {
			EmployeeAutoDao dao = (EmployeeAutoDao) container
					.getComponent(EmployeeAutoDao.class);/* 菇2 */
			
			Employee emp = new Employee();

			emp.setJob( "MANAGER"   );
			emp.setDeptno( new Integer(20)   );
			
			List ret = dao.getEmployeeByEmployeeDtoAuto(emp);
			
			System.out.println("RET:" + ((Employee)ret.get(0) ).getEname());/* 菇3 */


		} finally {
			container.destroy();
		}

	}
	
}