package examples.hibernate3.client;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;

import examples.hibernate.dao.DepartmentAutoDao;
import examples.hibernate.entity.Department;

public class DepartmentAutoDaoClient {

	private static final String PATH = 
				"examples/hibernate3/client/DepartmentAutoDao.dicon";

	public static void main(String[] args) {
		S2Container container = S2ContainerFactory.create(PATH);/* 菇1 */
		container.init();
		try {
			DepartmentAutoDao dao = (DepartmentAutoDao) container
					.getComponent(DepartmentAutoDao.class);/* 菇2 */
			
			Department dept = dao.getDepartmentByDeptno((short)30);
			System.out.println(dept);

//			List list = dao.findAll();
//			System.out.println(list);
			
		} finally {
			container.destroy();
		}

	}
}