/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.util.NamingHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatasourceConnectionProvider
implements ConnectionProvider {
    private DataSource ds;
    private String user;
    private String pass;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$connection$DatasourceConnectionProvider == null ? (class$net$sf$hibernate$connection$DatasourceConnectionProvider = DatasourceConnectionProvider.class$("net.sf.hibernate.connection.DatasourceConnectionProvider")) : class$net$sf$hibernate$connection$DatasourceConnectionProvider));
    static /* synthetic */ Class class$net$sf$hibernate$connection$DatasourceConnectionProvider;

    public void configure(Properties props) throws HibernateException {
        String jndiName = props.getProperty("hibernate.connection.datasource");
        if (jndiName == null) {
            String msg = "datasource JNDI name was not specified by property hibernate.connection.datasource";
            log.fatal((Object)msg);
            throw new HibernateException(msg);
        }
        this.user = props.getProperty("hibernate.connection.username");
        this.pass = props.getProperty("hibernate.connection.password");
        try {
            this.ds = (DataSource)NamingHelper.getInitialContext(props).lookup(jndiName);
        }
        catch (Exception e) {
            log.fatal((Object)("Could not find datasource: " + jndiName), (Throwable)e);
            throw new HibernateException("Could not find datasource", e);
        }
        if (this.ds == null) {
            throw new HibernateException("Could not find datasource: " + jndiName);
        }
        log.info((Object)("Using datasource: " + jndiName));
    }

    public Connection getConnection() throws SQLException {
        if (this.user != null || this.pass != null) {
            return this.ds.getConnection(this.user, this.pass);
        }
        return this.ds.getConnection();
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

