package test.org.seasar.hibernate.dao.impl;

import java.math.BigDecimal;

import java.util.List;

import org.seasar.extension.unit.S2TestCase;

import examples.hibernate.dao.EmployeeAutoDao;
import examples.hibernate.dto.EmployeeSalDto;

public class EmployeeHQLDtoTest extends S2TestCase {

	private EmployeeAutoDao dao_;
	/**
	 * Constructor for S2SessionFactoryImplTest.
	 * @param arg0
	 */
	public EmployeeHQLDtoTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(EmployeeHQLDtoTest.class);
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		include("examples/hibernate/client/EmployeeAutoDao.dicon");
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	public void testGetEmployeeBySalDto(){
		EmployeeSalDto dto = new EmployeeSalDto();
		dto.setFromSal(new BigDecimal(1000));
		dto.setToSal(new BigDecimal(2000));
		
		List ret = dao_.getEmployeeBySalDto( dto);
		assertEquals(6,ret.size() );

	}
	
	
	
}