package examples.hibernate.client;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;

import examples.hibernate.dao.EmployeeAutoDao;
import examples.hibernate.entity.Employee;

public class EmployeeAutoDaoClient {

	private static final String PATH = 
				"examples/hibernate/client/EmployeeAutoDao.dicon";

	public static void main(String[] args) {
		S2Container container = S2ContainerFactory.create(PATH);/* 菇1 */
		container.init();
		try {
			EmployeeAutoDao dao = (EmployeeAutoDao) container
					.getComponent(EmployeeAutoDao.class);/* 菇2 */
			Employee emp = new Employee();
			emp.setEmpno( new Integer(7788) );
			emp.setEname( "SCOTT");
			emp.setDeptno( new Integer(10) );

			dao.save( emp );	/* 菇3 */
					
//			dao.delete( emp );	

		} finally {
			container.destroy();
		}

	}
}