/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.ScrollMode;
import net.sf.hibernate.engine.Batcher;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.exception.JDBCExceptionHelper;
import net.sf.hibernate.util.GetGeneratedKeysHelper;
import net.sf.hibernate.util.JDBCExceptionReporter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BatcherImpl
implements Batcher {
    private static int openPreparedStatements;
    private static int openResultSetCount;
    protected static final Log log;
    protected static final Log sqlLog;
    private final SessionImplementor session;
    private final SessionFactoryImplementor factory;
    private PreparedStatement batchUpdate;
    private String batchUpdateSQL;
    private HashSet statementsToClose = new HashSet();
    private HashSet resultSetsToClose = new HashSet();
    private PreparedStatement lastQuery;
    static /* synthetic */ Class class$net$sf$hibernate$impl$BatcherImpl;

    public BatcherImpl(SessionImplementor session) {
        this.session = session;
        this.factory = session.getFactory();
    }

    protected PreparedStatement getStatement() {
        return this.batchUpdate;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException, HibernateException {
        return this.prepareStatement(sql, false);
    }

    public PreparedStatement prepareStatement(String sql, boolean getGeneratedKeys) throws SQLException, HibernateException {
        this.executeBatch();
        BatcherImpl.logOpenPreparedStatement();
        return this.getPreparedStatement(this.session.connection(), sql, false, getGeneratedKeys, null);
    }

    public PreparedStatement prepareQueryStatement(String sql, boolean scrollable, ScrollMode scrollMode) throws SQLException, HibernateException {
        BatcherImpl.logOpenPreparedStatement();
        PreparedStatement ps = this.getPreparedStatement(this.session.connection(), sql, scrollable, scrollMode);
        this.setStatementFetchSize(ps);
        this.statementsToClose.add(ps);
        this.lastQuery = ps;
        return ps;
    }

    public void abortBatch(SQLException sqle) {
        PreparedStatement ps = this.batchUpdate;
        this.batchUpdate = null;
        this.batchUpdateSQL = null;
        try {
            this.closeStatement(ps);
        }
        catch (SQLException e) {
            JDBCExceptionReporter.logExceptions(e);
        }
    }

    public ResultSet getResultSet(PreparedStatement ps) throws SQLException {
        ResultSet rs = ps.executeQuery();
        this.resultSetsToClose.add(rs);
        BatcherImpl.logOpenResults();
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeQueryStatement(PreparedStatement ps, ResultSet rs) throws SQLException {
        this.statementsToClose.remove(ps);
        if (rs != null) {
            this.resultSetsToClose.remove(rs);
        }
        try {
            if (rs != null) {
                BatcherImpl.logCloseResults();
                rs.close();
            }
        }
        finally {
            this.closeQueryStatement(ps);
        }
    }

    public PreparedStatement prepareBatchStatement(String sql) throws SQLException, HibernateException {
        if (!sql.equals(this.batchUpdateSQL)) {
            this.batchUpdate = this.prepareStatement(sql);
            this.batchUpdateSQL = sql;
        } else {
            log.debug((Object)"reusing prepared statement");
            this.log(sql);
        }
        return this.batchUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch() throws HibernateException {
        if (this.batchUpdate != null) {
            PreparedStatement ps = this.batchUpdate;
            this.batchUpdate = null;
            this.batchUpdateSQL = null;
            try {
                try {
                    this.doExecuteBatch(ps);
                }
                finally {
                    this.closeStatement(ps);
                }
            }
            catch (SQLException sqle) {
                throw this.convert(sqle, "Could not execute JDBC batch update");
            }
        }
    }

    public void closeStatement(PreparedStatement ps) throws SQLException {
        BatcherImpl.logClosePreparedStatement();
        this.closePreparedStatement(ps);
    }

    private void closeQueryStatement(PreparedStatement ps) throws SQLException {
        try {
            if (ps.getMaxRows() != 0) {
                ps.setMaxRows(0);
            }
            if (ps.getQueryTimeout() != 0) {
                ps.setQueryTimeout(0);
            }
        }
        catch (Exception e) {
            log.warn((Object)"exception clearing maxRows/queryTimeout", (Throwable)e);
            ps.close();
            return;
        }
        this.closeStatement(ps);
        if (this.lastQuery == ps) {
            this.lastQuery = null;
        }
    }

    public void closeStatements() {
        try {
            if (this.batchUpdate != null) {
                this.batchUpdate.close();
            }
        }
        catch (SQLException sqle) {
            log.warn((Object)"Could not close a JDBC prepared statement", (Throwable)sqle);
        }
        this.batchUpdate = null;
        this.batchUpdateSQL = null;
        Iterator iter = this.resultSetsToClose.iterator();
        while (iter.hasNext()) {
            try {
                BatcherImpl.logCloseResults();
                ((ResultSet)iter.next()).close();
            }
            catch (SQLException e) {
                log.warn((Object)"Could not close a JDBC result set", (Throwable)e);
            }
        }
        this.resultSetsToClose.clear();
        iter = this.statementsToClose.iterator();
        while (iter.hasNext()) {
            try {
                this.closeQueryStatement((PreparedStatement)iter.next());
            }
            catch (SQLException e) {
                log.warn((Object)"Could not close a JDBC statement", (Throwable)e);
            }
        }
        this.statementsToClose.clear();
    }

    protected abstract void doExecuteBatch(PreparedStatement var1) throws SQLException, HibernateException;

    private static void logOpenPreparedStatement() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("about to open: " + openPreparedStatements + " open PreparedStatements, " + openResultSetCount + " open ResultSets"));
            ++openPreparedStatements;
        }
    }

    private static void logClosePreparedStatement() {
        if (log.isTraceEnabled()) {
            --openPreparedStatements;
        }
        log.trace((Object)("done closing: " + openPreparedStatements + " open PreparedStatements, " + openResultSetCount + " open ResultSets"));
    }

    private static void logOpenResults() {
        if (log.isTraceEnabled()) {
            ++openResultSetCount;
        }
    }

    private static void logCloseResults() {
        if (log.isTraceEnabled()) {
            --openResultSetCount;
        }
    }

    protected SessionImplementor getSession() {
        return this.session;
    }

    protected SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    private void log(String sql) {
        sqlLog.debug((Object)sql);
        if (this.factory.isShowSqlEnabled()) {
            System.out.println("Hibernate: " + sql);
        }
    }

    private PreparedStatement getPreparedStatement(Connection conn, String sql, boolean scrollable, ScrollMode scrollMode) throws SQLException {
        return this.getPreparedStatement(conn, sql, scrollable, false, scrollMode);
    }

    private PreparedStatement getPreparedStatement(Connection conn, String sql, boolean scrollable, boolean useGetGeneratedKeys, ScrollMode scrollMode) throws SQLException {
        if (scrollable && !this.factory.isScrollableResultSetsEnabled()) {
            throw new AssertionFailure("scrollable result sets disabled");
        }
        if (useGetGeneratedKeys && !this.factory.isGetGeneratedKeysEnabled()) {
            throw new AssertionFailure("getGeneratedKeys() disabled");
        }
        this.log(sql);
        try {
            log.trace((Object)"preparing statement");
            if (scrollable) {
                if (scrollMode == null) {
                    scrollMode = ScrollMode.SCROLL_INSENSITIVE;
                }
                return conn.prepareStatement(sql, scrollMode.toResultSetType(), 1007);
            }
            if (useGetGeneratedKeys) {
                return GetGeneratedKeysHelper.prepareStatement(conn, sql);
            }
            return conn.prepareStatement(sql);
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    private void closePreparedStatement(PreparedStatement ps) throws SQLException {
        try {
            log.trace((Object)"closing statement");
            ps.close();
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    private void setStatementFetchSize(PreparedStatement statement) throws SQLException {
        Integer statementFetchSize = this.factory.getJdbcFetchSize();
        if (statementFetchSize != null) {
            statement.setFetchSize(statementFetchSize);
        }
    }

    public Connection openConnection() throws HibernateException {
        try {
            return this.factory.getConnectionProvider().getConnection();
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "Cannot open connection");
        }
    }

    public void closeConnection(Connection conn) throws HibernateException {
        try {
            if (!conn.isClosed()) {
                try {
                    JDBCExceptionReporter.logWarnings(conn.getWarnings());
                    conn.clearWarnings();
                }
                catch (SQLException sqle) {
                    log.debug((Object)"could not log warnings", (Throwable)sqle);
                }
            }
            this.factory.getConnectionProvider().closeConnection(conn);
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "Cannot close connection");
        }
    }

    public void cancelLastQuery() throws HibernateException {
        try {
            if (this.lastQuery != null) {
                this.lastQuery.cancel();
            }
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "Could not cancel query");
        }
    }

    protected JDBCException convert(SQLException sqlException, String message) {
        return JDBCExceptionHelper.convert(this.session.getFactory().getSQLExceptionConverter(), sqlException, message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = LogFactory.getLog((Class)(class$net$sf$hibernate$impl$BatcherImpl == null ? (class$net$sf$hibernate$impl$BatcherImpl = BatcherImpl.class$("net.sf.hibernate.impl.BatcherImpl")) : class$net$sf$hibernate$impl$BatcherImpl));
        sqlLog = LogFactory.getLog((String)"net.sf.hibernate.SQL");
    }
}

