/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.remoting.axis.deployer;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.axis.AxisEngine;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.MetaDefAware;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.remoting.axis.DeployFailedException;
import org.seasar.remoting.axis.deployer.HandlerDeployer;
import org.seasar.remoting.axis.deployer.ItemDeployer;
import org.seasar.remoting.axis.deployer.ServiceDeployer;
import org.seasar.remoting.axis.deployer.WSDDDeployer;
import org.seasar.remoting.common.deployer.Deployer;

public class AxisDeployer
implements Deployer {
    protected static final Pattern META_NAME_PATTERN = Pattern.compile("(?:s2-axis:|axis-)(.+)");
    protected S2Container container;
    protected ServletContext servletContext;
    protected ItemDeployer serviceDeployer = new ServiceDeployer(this);
    protected ItemDeployer handlerDeployer = new HandlerDeployer(this);
    protected ItemDeployer wsddDeployer = new WSDDDeployer(this);
    static /* synthetic */ Class class$javax$xml$rpc$Service;

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void deploy() {
        this.forEach(this.container.getRoot());
    }

    protected void forEach(S2Container container) {
        this.process(container);
        int componentDefSize = container.getComponentDefSize();
        for (int i = 0; i < componentDefSize; ++i) {
            this.process(container.getComponentDef(i));
        }
        int childContainerSize = container.getChildSize();
        for (int i = 0; i < childContainerSize; ++i) {
            this.forEach(container.getChild(i));
        }
    }

    protected void process(S2Container container) {
        MetaDef[] metaDefs = this.getMetaDefs((MetaDefAware)container, "deploy");
        for (int i = 0; metaDefs != null && i < metaDefs.length; ++i) {
            this.wsddDeployer.deploy(null, metaDefs[i]);
        }
    }

    protected void process(ComponentDef componentDef) {
        MetaDef handlerMetaDef;
        MetaDef serviceMetaDef = this.getMetaDef((MetaDefAware)componentDef, "service");
        if (serviceMetaDef != null) {
            this.serviceDeployer.deploy(componentDef, serviceMetaDef);
        }
        if ((handlerMetaDef = this.getMetaDef((MetaDefAware)componentDef, "handler")) != null) {
            this.handlerDeployer.deploy(componentDef, handlerMetaDef);
        }
    }

    protected WSDDDeployment getDeployment(S2Container container) {
        return ((WSDDEngineConfiguration)this.getEngine(container).getConfig()).getDeployment();
    }

    protected AxisEngine getEngine(S2Container container) {
        String engineName = "default";
        MetaDef metadata = this.getMetaDef((MetaDefAware)container, "engine");
        if (metadata != null) {
            engineName = (String)metadata.getValue();
        }
        if ("default".equals(engineName)) {
            engineName = this.servletContext == null ? "default-client" : "default-server";
        }
        AxisEngine engine = null;
        if ("default-client".equals(engineName)) {
            Service service = (Service)container.getComponent((Object)(class$javax$xml$rpc$Service == null ? (class$javax$xml$rpc$Service = AxisDeployer.class$("javax.xml.rpc.Service")) : class$javax$xml$rpc$Service));
            engine = service.getEngine();
        } else if ("default-server".equals(engineName)) {
            engine = (AxisEngine)this.servletContext.getAttribute("AxisServletAxisEngine");
            if (engine == null) {
                engine = (AxisEngine)this.servletContext.getAttribute("AxisEngine");
            }
        } else if (engineName.startsWith("servlet:")) {
            String servletName = engineName.substring("servlet:".length());
            engine = (AxisEngine)this.servletContext.getAttribute(servletName + "AxisEngine");
        } else if (engineName.startsWith("s2:")) {
            String componentName = engineName.substring("s2:".length());
            engine = (AxisEngine)container.getComponent((Object)componentName);
        } else {
            engine = (AxisEngine)container.getComponent((Object)engineName);
        }
        if (engine == null) {
            throw new DeployFailedException(MessageFormatter.getSimpleMessage((String)"EAXS0007", null));
        }
        return engine;
    }

    protected MetaDef getMetaDef(MetaDefAware metaDefSupport, String localName) {
        for (int i = 0; i < metaDefSupport.getMetaDefSize(); ++i) {
            MetaDef metaDef = metaDefSupport.getMetaDef(i);
            if (!localName.equals(this.getLocalName(metaDef))) continue;
            return metaDef;
        }
        return null;
    }

    protected MetaDef[] getMetaDefs(MetaDefAware metaDefSupport, String localName) {
        ArrayList<MetaDef> result = new ArrayList<MetaDef>();
        for (int i = 0; i < metaDefSupport.getMetaDefSize(); ++i) {
            MetaDef metaDef = metaDefSupport.getMetaDef(i);
            if (!localName.equals(this.getLocalName(metaDef))) continue;
            result.add(metaDef);
        }
        return result.toArray(new MetaDef[result.size()]);
    }

    protected String getLocalName(MetaDef metaDef) {
        Matcher matcher = META_NAME_PATTERN.matcher(metaDef.getName());
        return matcher.matches() ? matcher.group(1) : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

