package org.seasar.framework.exception;

import java.sql.SQLException;

import org.seasar.framework.message.MessageFormatter;

/**
 * @author higa
 *
 */
public class SSQLException extends SQLException {

	private String messageCode_;
	private Object[] args_;
	
	public SSQLException(String messageCode, Object[] args) {
	    this(messageCode, args, null, 0, null);
	}

	public SSQLException(String messageCode, Object[] args, Throwable cause) {
	    this(messageCode, args, null, 0, cause);
	}

	public SSQLException(String messageCode, Object[] args, String sqlState) {
	    this(messageCode, args, sqlState, 0, null);
	}

	public SSQLException(String messageCode, Object[] args, String sqlState, Throwable cause) {
	    this(messageCode, args, sqlState, 0, cause);
	}

	public SSQLException(String messageCode, Object[] args, String sqlState, int vendorCode) {
	    this(messageCode, args, sqlState, vendorCode, null);
	}

	public SSQLException(String messageCode, Object[] args, String sqlState, int vendorCode, Throwable cause) {
		super(MessageFormatter.getMessage(messageCode, args), sqlState, vendorCode);
		messageCode_ = messageCode;
		args_ = args;
		this.initCause(cause);
		if (cause instanceof SQLException) {
		    setNextException((SQLException) cause);
		}
	}

	public String getMessageCode() {
		return messageCode_;
	}
	
	public Object[] getArgs() {
		return args_;
	}
}
