package org.seasar.jsf.util;

import java.io.IOException;
import java.util.Iterator;

import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;

import org.seasar.framework.log.Logger;
import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.exception.NoValueHolderRuntimeException;
import org.seasar.jsf.exception.SubmittedValueNotStringRuntimeException;

/**
 * @author higa
 *  
 */
public final class RenderUtil {

	private static Logger logger = Logger.getLogger(RenderUtil.class);

	private RenderUtil() {
	}

	public static void encodeChildren(FacesContext context,
			UIComponent component) throws IOException {

		Iterator i = component.getChildren().iterator();
		while (i.hasNext()) {
			encodeChild(context, (UIComponent) i.next());
			if (context.getResponseComplete()) {
				break;
			}
		}
	}

	public static void encodeChild(FacesContext context, UIComponent component)
			throws IOException {

		component.encodeBegin(context);
		if (component.getRendersChildren()) {
			component.encodeChildren(context);
		} else {
			encodeChildren(context, component);
		}
		component.encodeEnd(context);
	}

	public static String getValueByString(FacesContext context,
			UIComponent component) {

		if (!(component instanceof ValueHolder)) {
			throw new NoValueHolderRuntimeException(component.getClass());
		}
		if (component instanceof EditableValueHolder) {
			EditableValueHolder evh = (EditableValueHolder) component;
			Object submittedValue = evh.getSubmittedValue();
			if (submittedValue != null) {
				if (submittedValue instanceof String) {
					return (String) submittedValue;
				} else {
					throw new SubmittedValueNotStringRuntimeException();
				}
			}
		}
		ValueHolder vh = (ValueHolder) component;
		Object value = vh.getValue();
		Converter converter = vh.getConverter();
		if (converter == null && value != null) {
			if (value instanceof String) {
				return (String) value;
			}
			try {
				converter = context.getApplication().createConverter(
						value.getClass());
			} catch (FacesException ex) {
				logger.log(ex);
			}
		}
		if (converter == null) {
			if (value == null) {
				return "";
			} else {
				return value.toString();
			}
		} else {
			return converter.getAsString(context, component, value);
		}
	}
	
	public static boolean renderAttributes(ResponseWriter writer,
            UIComponent component, String[] attributeNames) throws IOException {
		
        boolean somethingDone = false;
        for (int i = 0, len = attributeNames.length; i < len; i++) {
            String attrName = attributeNames[i];
            if (renderAttribute(writer, component, attrName)) {
                somethingDone = true;
            }
        }
        return somethingDone;
    }
	
	public static boolean renderAttribute(ResponseWriter writer,
            UIComponent component, String attributeName)
            throws IOException {
		
        Object value = component.getAttributes().get(attributeName);
        return renderAttribute(writer, attributeName, value, attributeName);
    }
	
	public static boolean renderAttribute(ResponseWriter writer, String attributeName,
			Object value, String propertyName) throws IOException {
		
		if (value == null) {
			return false;
		}
		if (attributeName.equalsIgnoreCase(JsfConstants.STYLE_CLASS_ATTR)) {
			attributeName = JsfConstants.CLASS_ATTR;
		}
		writer.writeAttribute(attributeName, value, propertyName);
		return true;
	}
}