/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.seasar.remoting.axis.deployer;

import javax.servlet.ServletContext;

import org.apache.axis.AxisEngine;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.remoting.axis.DeployFailedException;
import org.seasar.remoting.axis.S2AxisConstants;
import org.seasar.remoting.common.deployer.Deployer;

/**
 * dicont@CɋLqꂽR|[lgAxisɃfvC܂B
 * 
 * @author koichik
 */
public class AxisDeployer implements Deployer {
    //instance fields
    protected S2Container container;
    protected ServletContext servletContext;

    protected ItemDeployer serviceDeployer = new ServiceDeployer(this);
    protected ItemDeployer handlerDeployer = new HandlerDeployer(this);
    protected ItemDeployer wsddDeployer = new WSDDDeployer(this);

    /**
     * S2Reiݒ肵܂B
     * 
     * @param container
     *            S2Rei
     */
    public void setContainer(final S2Container container) {
        this.container = container;
    }

    /**
     * T[ubgReLXgݒ肵܂B
     * 
     * @param servletContext
     *            T[ubgReLXg
     */
    public void setServletContext(final ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    /**
     * Reiɓo^ĂT[rXnhfvC܂B
     */
    public void deploy() {
        forEach(container.getRoot());
    }

    /**
     * Rei̊KwǂđSẴReiƃR|[lg`𑖍܂B <br>
     * 鏇͎̒ʂłB
     * <ol>
     * <li>Reig</li>
     * <li>q̃R|[lg`</li>
     * <li>q̃ReiċNI</li>
     * </ol>
     * 
     * @param container
     *            N_ƂȂRei
     */
    protected void forEach(final S2Container container) {
        process(container);

        final int componentDefSize = container.getComponentDefSize();
        for (int i = 0; i < componentDefSize; ++i) {
            process(container.getComponentDef(i));
        }

        final int childContainerSize = container.getChildSize();
        for (int i = 0; i < childContainerSize; ++i) {
            forEach(container.getChild(i));
        }
    }

    /**
     * S2ReiS2Axis̃^f[^ <code>&lt;meta name="s2axis:deploy"&gt;</code>
     * w肳Ă΁AWSDDAxisɃfvC܂B
     * 
     * @param container
     *            S2Rei
     */
    protected void process(final S2Container container) {
        final MetaDef[] metaDefs = container.getMetaDefs(S2AxisConstants.META_S2AXIS_DEPLOY);
        for (int i = 0; metaDefs != null && i < metaDefs.length; ++i) {
            wsddDeployer.deploy(null, metaDefs[i]);
        }
    }

    /**
     * R|[lg`S2Axis̃^f[^ <code>&lt;meta name="s2axis:service"&gt;</code>
     * ܂ <code>&lt;meta name="s2axis:handler"&gt;</code>
     * w肳Ă΁ÃR|[lgT[rX܂̓nhƂAxisɃfvC܂B
     * 
     * @param componentDef
     *            R|[lg`
     */
    protected void process(final ComponentDef componentDef) {
        final MetaDef serviceMetaDef = componentDef.getMetaDef(S2AxisConstants.META_S2AXIS_SERVICE);
        if (serviceMetaDef != null) {
            serviceDeployer.deploy(componentDef, serviceMetaDef);
        }

        final MetaDef handlerMetaDef = componentDef.getMetaDef(S2AxisConstants.META_S2AXIS_HANDLER);
        if (handlerMetaDef != null) {
            handlerDeployer.deploy(componentDef, handlerMetaDef);
        }
    }

    /**
     * WSDDfvCgԂ܂B
     * 
     * @param container
     *            Rei
     * @return WSDDfvCg
     */
    protected WSDDDeployment getDeployment(final S2Container container) {
        return ((WSDDEngineConfiguration) getEngine(container).getConfig()).getDeployment();
    }

    /**
     * AxisGWԂ܂B <br>
     * AxisGẂAReiɖO <code>s2-axis:engine</code> 
     * <code>&lt;meta&gt;</code> vfw肳Ă΁A̓e񂩂玟̂悤Ɍ肳܂B
     * <dl>
     * <dt>`̏ꍇ</dt>
     * <dd><code>"default"</code> w肳ꂽ̂ƂAxisGW肵܂B</dd>
     * <dt><code>"default"</code></dt>
     * <dd>ReiɃT[ubgReLXgݒ肳Ă <code>"default-server"</code> AłȂ
     * <code>"default-client"</code> w肳ꂽ̂ƂAxisGW肵܂B</dd>
     * <dt><code>"default-client"</code></dt>
     * <dd>Rei <code>javax.xml.rpc.Service</code>
     * R|[lg擾ÃGWgp܂B</dd>
     * <dt><code>"default-server"</code></dt>
     * <dd>T[ubgReLXgɐݒ肳ĂAxisGWgp܂B <br>
     * ŏ {@link S2AxisConstants#AXIS_SERVLET}
     * {@link S2AxisConstants#ATTR_AXIS_ENGINE}AL[Ƃ
     * T[ubgReLXgAxisGW擾܂B <br>
     * Ȃꍇ{S2AxisConstants#ATTR_AXIS_ENGINE}
     * L[ƂăT[ubgReLXg擾AxisGW擾܂B <br>
     * </dd>
     * <dt><code>"servlet:"</code> Ŏn܂镶</dt>
     * <dd><code>"servlet:"</code> ̌̕L[ƂăT[ubgReLXg
     * 擾AxisGWgp܂B
     * <dd>
     * <dt><code>"s2:"</code> Ŏn܂镶</dt>
     * <dd><code>"s2:"</code> ̌̕L[ƂS2Rei
     * 擾R|[lgAxisGWgp܂B</dd>
     * <dt>̑</dt>
     * <dd>L[ƂS2Rei擾R|[lgAxisGWƂĎgp܂B</dd>
     * </dl>
     * 
     * @param container
     *            Rei
     * @return AxisGW
     */
    protected AxisEngine getEngine(final S2Container container) {
        String engineName = S2AxisConstants.ENGINE_DEFAULT;

        final MetaDef metadata = container.getMetaDef(S2AxisConstants.META_S2AXIS_ENGINE);
        if (metadata != null) {
            engineName = (String) metadata.getValue();
        }

        if (S2AxisConstants.ENGINE_DEFAULT.equals(engineName)) {
            if (servletContext == null) {
                engineName = S2AxisConstants.ENGINE_DEFAULT_CLIENT;
            }
            else {
                engineName = S2AxisConstants.ENGINE_DEFAULT_SERVER;
            }
        }

        AxisEngine engine = null;
        if (S2AxisConstants.ENGINE_DEFAULT_CLIENT.equals(engineName)) {
            final Service service = (Service) container.getComponent(javax.xml.rpc.Service.class);
            engine = service.getEngine();
        }
        else if (S2AxisConstants.ENGINE_DEFAULT_SERVER.equals(engineName)) {
            engine = (AxisEngine) servletContext.getAttribute(S2AxisConstants.AXIS_SERVLET
                    + S2AxisConstants.ATTR_AXIS_ENGINE);
            if (engine == null) {
                engine = (AxisEngine) servletContext.getAttribute(S2AxisConstants.ATTR_AXIS_ENGINE);
            }
        }
        else if (engineName.startsWith(S2AxisConstants.ENGINE_FROM_SERVLET)) {
            final String servletName = engineName.substring(S2AxisConstants.ENGINE_FROM_SERVLET
                    .length());
            engine = (AxisEngine) servletContext.getAttribute(servletName
                    + S2AxisConstants.ATTR_AXIS_ENGINE);
        }
        else if (engineName.startsWith(S2AxisConstants.ENGINE_FROM_S2CONTAINER)) {
            final String componentName = engineName
                    .substring(S2AxisConstants.ENGINE_FROM_S2CONTAINER.length());
            engine = (AxisEngine) container.getComponent(componentName);
        }
        else {
            engine = (AxisEngine) container.getComponent(engineName);
        }

        if (engine == null) {
            throw new DeployFailedException(MessageFormatter.getSimpleMessage("EAXS0007", null));
        }
        return engine;
    }
}
