package test.org.seasar.extension.openamf.invoke;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import junit.framework.Assert;

/**
 * 
 * @author Hidetoshi Hosokawa
 */
public class InvokeTestImpl extends Assert implements InvokeTest {

	public static void main(String[] args) {
		junit.textui.TestRunner.run(InvokeTest.class);
	}

	public String test1() throws Exception {
		return "test1";
	}
	
	public String test2(Map map) throws Exception {
		assertNotNull(map);
		assertEquals(map.get("id"), "ID");
		assertEquals(map.get("name"), "NAME");
		assertEquals(map.get("number"), new Double("100.0"));
		assertNull(map.get("bean"));

		return "test2";
	}
	
	public String test3(TestBean1 bean1) throws Exception {
		assertNotNull(bean1);
		assertEquals(bean1.getId(), "ID");
		assertEquals(bean1.getName(), "NAME");
		assertEquals(bean1.getNumber(), 100);
		assertNull(bean1.getBean());

		return "test3";
	}

	public String test4(TestBean1 bean1, TestBean2 bean2) throws Exception {
		assertNotNull(bean1);
		assertEquals(bean1.getId(), "ł[");
		assertEquals(bean1.getName(), "ˁ[");
		assertEquals(bean1.getNumber(), 1234);
		assertNotNull(bean1.getBean());

		assertNotNull(bean2);
		assertEquals(bean2.getId(), "ACfB[");
		assertEquals(bean2.getName(), "l[");
		assertEquals(bean2.getNumber(), 4321);

		assertNotNull(bean1.getBean());
		TestBean2 bean = bean1.getBean();
		assertNotNull(bean);
		assertEquals(bean.getId(), "ACfB[");
		assertEquals(bean.getName(), "l[");
		assertEquals(bean.getNumber(), 4321);

		return "test4";
	}
	
	public String test5(List list) throws Exception {
		assertNotNull(list);
		assertEquals(list.size(), 3);
		
		for (int i = 0; i < list.size(); i++) {
			Object obj = list.get(i);
			assertTrue(obj instanceof TestBean1);
			TestBean1 bean = (TestBean1) obj;
			assertNotNull(bean);
			assertEquals(bean.getId(), "ID" + i);
		}
		return "test5";
	}

	public String test6(List list) throws Exception {
		assertNotNull(list);
		assertEquals(list.size(), 3);
		
		for (int i = 0; i < list.size(); i++) {
			Object obj = list.get(i);
			assertTrue(obj instanceof Map);
			Map map = (Map) obj;
			assertNotNull(map);
			assertEquals(map.get("id"), "ID" + i);
		}
		return "test6";
	}
	
	public String test7(TestBean1 bean) throws Exception {
		assertNotNull(bean);
		assertEquals(bean.getId(), "ID");
		assertEquals(bean.getName(), "NAME");
		assertEquals(bean.getNumber(), 100);
		assertNotNull(bean.getBean());
		assertNotNull(bean.getList());
		
		TestBean2 bean2 = bean.getBean();
		assertEquals(bean2.getId(), "ID2");
		assertEquals(bean2.getName(), "NAME2");
		assertEquals(bean2.getNumber(), 200);
		assertNotNull(bean2.getBean());
		assertNotNull(bean2.getList());

		TestBean3 bean3 = bean2.getBean();
		assertEquals(bean3.getMyId(), "my id");
		assertEquals(bean3.getMyName(), "my name");
		
		List list1 = bean.getList();
		assertEquals(list1.size(), 1);
		assertTrue(list1.get(0) instanceof TestBean2);
		assertEquals(((TestBean2)list1.get(0)).getId(), "ID2");

		List list2 = bean2.getList();
		assertEquals(list2.size(), 1);
		assertTrue(list2.get(0) instanceof TestBean3);
		assertEquals(((TestBean3)list2.get(0)).getMyId(), "my id");

		return "test7";
	}
	
	public String test8(int num) throws Exception {
		assertEquals(num, 1234);
		return "test8";
	}
	public String test9(long num) throws Exception {
		assertEquals(num, 10000000000L);
		return "test9";
	}
	
	public String test10(boolean bool) throws Exception {
		assertTrue(bool);
		return "test10";
	}
	
	public String test11(String string) throws Exception {
		assertEquals(string, "eXg");
		return "test11";
	}

	public List test12() throws Exception {		
		TestBean1 bean1 = new TestBean1();
		bean1.setId("serverID1");
		bean1.setName("serverName1");
		bean1.setNumber(1024);

		TestBean1 bean2 = new TestBean1();
		bean2.setId("serverID2");
		bean2.setName("serverName2");
		bean2.setNumber(2048);

		List list = new ArrayList();
		list.add(bean1);
		list.add(bean2);

		return list;
	}

	public TestBean3 test13() throws Exception {
		TestBean3 bean = new TestBean3();
		bean.setMyId("serverID");
		bean.setMyName("serverName");
		return bean;
	}
}
