/*
 * Decompiled with CFR 0.152.
 */
package org.openamf;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openamf.AMFBody;
import org.openamf.AMFHeader;
import org.openamf.AMFMessage;

public class AMFMessageTest
extends TestCase {
    private static final Log log = LogFactory.getLog((Class)(class$org$openamf$AMFMessageTest == null ? (class$org$openamf$AMFMessageTest = AMFMessageTest.class$("org.openamf.AMFMessageTest")) : class$org$openamf$AMFMessageTest));
    static /* synthetic */ Class class$org$openamf$AMFMessageTest;

    public AMFMessageTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(class$org$openamf$AMFMessageTest == null ? (class$org$openamf$AMFMessageTest = AMFMessageTest.class$("org.openamf.AMFMessageTest")) : class$org$openamf$AMFMessageTest);
        return suite;
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testAddHeader() {
        AMFMessage message = new AMFMessage();
        AMFHeader header = new AMFHeader("testKey1", true, "testValue1");
        message.addHeader(header);
        message.addHeader("testKey2", false, "testValue2");
        log.debug((Object)("Message is " + message));
        Assert.assertEquals((int)2, (int)message.getHeaderCount());
        Assert.assertTrue((boolean)message.getHeaders().contains(header));
    }

    public void testAddBody() {
        AMFMessage message = new AMFMessage();
        AMFBody body = new AMFBody("someService.someMethod", "someResponse", "body value", 2);
        message.addBody(body);
        log.debug((Object)("Message is " + message));
        Assert.assertEquals((int)1, (int)message.getBodyCount());
        Assert.assertEquals((Object)body, (Object)message.getBody(0));
    }

    public void testVersion() {
        int iFiftySix = 56;
        int iTwoHundred = 200;
        AMFMessage message = new AMFMessage();
        message.setVersion(56);
        Assert.assertEquals((int)56, (int)message.getVersion());
        message.setVersion(200);
        Assert.assertEquals((int)200, (int)message.getVersion());
    }

    public void testCount() {
        AMFMessage message = new AMFMessage();
        Assert.assertEquals((int)0, (int)message.getHeaderCount());
        Assert.assertEquals((int)0, (int)message.getHeaders().size());
        Assert.assertEquals((int)0, (int)message.getBodyCount());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

