/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.tools.ant.Location;

public class BuildException
extends RuntimeException {
    private Throwable cause;
    private Location location = Location.UNKNOWN_LOCATION;

    public BuildException() {
    }

    public BuildException(String message) {
        super(message);
    }

    public BuildException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    public BuildException(String msg, Throwable cause, Location location) {
        this(msg, cause);
        this.location = location;
    }

    public BuildException(Throwable cause) {
        super(cause.toString());
        this.cause = cause;
    }

    public BuildException(String message, Location location) {
        super(message);
        this.location = location;
    }

    public BuildException(Throwable cause, Location location) {
        this(cause);
        this.location = location;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public Throwable getException() {
        return this.cause;
    }

    public String toString() {
        return this.location.toString() + this.getMessage();
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            super.printStackTrace(ps);
            if (this.cause != null) {
                ps.println("--- Nested Exception ---");
                this.cause.printStackTrace(ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            super.printStackTrace(pw);
            if (this.cause != null) {
                pw.println("--- Nested Exception ---");
                this.cause.printStackTrace(pw);
            }
        }
    }
}

