package org.seasar.extension.openamf;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import org.openamf.ServiceRequest;
import org.openamf.invoker.ServiceInvocationException;
import org.openamf.invoker.ServiceInvoker;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.servlet.S2ContainerServlet;

/**
 * Flash RemotinggSeasar2̃R|[lgĂяo
 * OpenAMF̃vOCłB
 *
 * @author hosokawa
 */
public class S2ServiceInvoker extends ServiceInvoker {

	/**
	 * ftHg̃RXgN^łB
	 * 
	 * @param request ServiceRequest
	 * @param httpServletRequest HttpServletRequest
	 * @param servletContext ServletContext
	 */
	public S2ServiceInvoker(
		ServiceRequest request,
		HttpServletRequest httpServletRequest,
		ServletContext servletContext) {

		super(request, httpServletRequest, servletContext);
	}

	/**
	 * R|[lǧĂяos܂B
	 */
	public Object invokeService() throws ServiceInvocationException {
		String serviceName = super.request.getServiceName();
		String methodName = super.request.getServiceMethodName();

		S2Container container = S2ContainerServlet.getContainer();

		Object component = null;
		Object result = null;
		try {
			if (container.hasComponentDef(serviceName)) {
				component = container.getComponent(serviceName);
			} else {
				component = container.getComponent(Class.forName(serviceName));
			}

			Object[] parameters = request.getParameters().toArray();
				
			ASTranslator ast = new ASTranslator();
			for (int i = 0; i < parameters.length; i++) {
				Object conv = ast.fromActionScript(parameters[i]);
				parameters[i] = conv;
			}

			BeanDesc beanDesc =
				BeanDescFactory.getBeanDesc(component.getClass());
			result = beanDesc.invoke(component, methodName, parameters);
		} catch (Exception e) {
			Throwable cause = e.getCause();
			if (cause == null) {
				cause = e;
			}
			throw new ServiceInvocationException(request, cause);
		}
		return result;
	}

	/**
	 * NCAg̃NGXgSeasar2ւ̃NGXg肵܂B
	 * 
	 * @param request ServiceRequest
	 * @return Seasar2ւ̃NGXg̏ꍇtrue
	 */
	public boolean supports(ServiceRequest request) {
		S2Container container = S2ContainerServlet.getContainer();

		String serviceName = request.getServiceName();
		if (container.hasComponentDef(serviceName)) {
			return true;
		} else {
			try {
				return container.hasComponentDef(Class.forName(serviceName));
			} catch (ClassNotFoundException e) {
				return false;
			}
		}
	}
}
