/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.xml.sax.InputSource;

public class ExtensionsResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private PrintWriter writer = null;

    public ExtensionsResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public byte[] getBytes() {
        return this.stream.toByteArray();
    }

    public String toString() {
        try {
            return this.stream.toString(this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Response accepted invalid character encoding " + this.getCharacterEncoding());
        }
    }

    public PrintWriter getWriter() {
        if (this.writer == null) {
            this.writer = new PrintWriter(this.stream, true);
        }
        return this.writer;
    }

    public ServletOutputStream getOutputStream() {
        return new MyServletOutputStream(this.stream);
    }

    public InputSource getInputSource() {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.stream.toByteArray());
        return new InputSource(bais);
    }

    public void setContentLength(int contentLength) {
    }

    public void flushBuffer() throws IOException {
        this.stream.flush();
    }

    public void finishResponse() {
        try {
            if (this.writer != null) {
                this.writer.close();
            } else if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class MyServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream outputStream;

        public MyServletOutputStream(ByteArrayOutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public void write(int b) {
            this.outputStream.write(b);
        }

        public void write(byte[] bytes) throws IOException {
            this.outputStream.write(bytes);
        }

        public void write(byte[] bytes, int off, int len) {
            this.outputStream.write(bytes, off, len);
        }
    }
}

