/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUpload;
import org.apache.myfaces.component.html.util.AddResource;
import org.apache.myfaces.component.html.util.ExtensionsResponseWrapper;
import org.apache.myfaces.component.html.util.MultipartRequestWrapper;

public class ExtensionsFilter
implements Filter {
    private int uploadMaxFileSize = 0x6400000;
    private int uploadThresholdSize = 0x100000;
    private String uploadRepositoryPath = null;

    public void init(FilterConfig filterConfig) {
        String param = filterConfig.getInitParameter("uploadMaxFileSize");
        this.uploadMaxFileSize = this.resolveSize(param, this.uploadMaxFileSize);
        param = filterConfig.getInitParameter("uploadThresholdSize");
        this.uploadThresholdSize = this.resolveSize(param, this.uploadThresholdSize);
        this.uploadRepositoryPath = filterConfig.getInitParameter("uploadRepositoryPath");
    }

    private int resolveSize(String param, int defaultValue) {
        int numberParam = defaultValue;
        if (param != null) {
            param = param.toLowerCase();
            int factor = 1;
            String number = param;
            if (param.endsWith("g")) {
                factor = 0x40000000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("m")) {
                factor = 0x100000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("k")) {
                factor = 1024;
                number = param.substring(0, param.length() - 1);
            }
            numberParam = Integer.parseInt(number) * factor;
        }
        return numberParam;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (AddResource.isResourceMappedPath(httpRequest)) {
            AddResource.serveResource(httpRequest, response);
            return;
        }
        Object extendedRequest = httpRequest;
        if (FileUpload.isMultipartContent((HttpServletRequest)httpRequest)) {
            extendedRequest = new MultipartRequestWrapper(httpRequest, this.uploadMaxFileSize, this.uploadThresholdSize, this.uploadRepositoryPath);
        }
        if (!(response instanceof HttpServletResponse)) {
            chain.doFilter((ServletRequest)extendedRequest, response);
            return;
        }
        ExtensionsResponseWrapper extendedResponse = new ExtensionsResponseWrapper((HttpServletResponse)response);
        chain.doFilter((ServletRequest)extendedRequest, (ServletResponse)extendedResponse);
        if (!AddResource.hasAdditionalHeaderInfoToRender(extendedRequest)) {
            response.getOutputStream().write(extendedResponse.getBytes());
            return;
        }
        AddResource.writeWithFullHeader(extendedRequest, extendedResponse, (HttpServletResponse)response);
    }

    public void destroy() {
    }
}

