/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.AbstractCriterion;
import net.sf.hibernate.util.StringHelper;

public abstract class SimpleExpression
extends AbstractCriterion {
    private final String propertyName;
    private final Object value;
    private boolean ignoreCase;

    SimpleExpression(String propertyName, Object value) {
        this.propertyName = propertyName;
        this.value = value;
    }

    SimpleExpression(String propertyName, Object value, boolean ignoreCase) {
        this.propertyName = propertyName;
        this.value = value;
        this.ignoreCase = ignoreCase;
    }

    public SimpleExpression ignoreCase() {
        this.ignoreCase = true;
        return this;
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias, Map aliasClasses) throws HibernateException {
        String[] columns = SimpleExpression.getColumns(sessionFactory, persistentClass, this.propertyName, alias, aliasClasses);
        if (this.ignoreCase) {
            if (columns.length != 1) {
                throw new HibernateException("case insensitive expression may only be applied to single-column properties: " + this.propertyName);
            }
            return sessionFactory.getDialect().getLowercaseFunction() + "(" + columns[0] + ")" + this.getOp() + "?";
        }
        String result = StringHelper.join(" and ", StringHelper.suffix(columns, this.getOp() + "?"));
        if (columns.length > 1) {
            result = "(" + result + ")";
        }
        return result;
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass, Map aliasClasses) throws HibernateException {
        Object icvalue = this.ignoreCase ? this.value.toString().toLowerCase() : this.value;
        return new TypedValue[]{SimpleExpression.getTypedValue(sessionFactory, persistentClass, this.propertyName, icvalue, aliasClasses)};
    }

    public String toString() {
        return this.propertyName + this.getOp() + this.value;
    }

    abstract String getOp();
}

