/*
 * 쐬F 2004/08/19
 */
package org.seasar.tapestry.engine;

import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.html.BasePage;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.tapestry.pageinjection.Injection;
import org.seasar.tapestry.pageinjection.impl.NullInjection;

/**
 * ver 3.0.2
 * 
 * @author maruo_syunsuke
 */
public class S2PageLoader extends CopyOfPageLoader {
    private Injection _injection = new NullInjection();

    public S2PageLoader( IRequestCycle cycle ) {
        super(cycle);
    }

    public String getDefaultPage() {
        return BasePage.class.getName();
    }

    public IPage getPageComponent( Class pageClass )
            throws InstantiationException, IllegalAccessException {
        IPage result = null;
        S2Container container = SingletonS2ContainerFactory.getContainer();
        if( container.hasComponentDef(pageClass) ){
            result = (IPage)container.getComponent(pageClass);
        } else{
            result = (IPage)pageClass.newInstance();
        }
        _injection.invoke(result);
        return result;
    }
    public void setInjection( Injection injection ) {
        if( injection == null ) return ;
        this._injection = injection;
    }
}