/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.MethodUtil;

public class PrototypeDelegateInterceptor
extends AbstractInterceptor {
    private S2Container container;
    private String targetName;
    private BeanDesc beanDesc;
    private Map methodNameMap = new HashMap();

    public PrototypeDelegateInterceptor(S2Container container) {
        this.container = container;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public void addMethodNameMap(String methodName, String targetMethodName) {
        this.methodNameMap.put(methodName, targetMethodName);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.targetName == null) {
            throw new EmptyRuntimeException("targetName");
        }
        Method method = invocation.getMethod();
        if (!MethodUtil.isAbstract(method)) {
            return invocation.proceed();
        }
        String methodName = method.getName();
        if (this.methodNameMap.containsKey(methodName)) {
            methodName = (String)this.methodNameMap.get(methodName);
        }
        Object target = this.container.getComponent(this.targetName);
        if (this.beanDesc == null) {
            this.beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
        }
        if (!this.beanDesc.hasMethod(methodName)) {
            throw new MethodNotFoundRuntimeException(this.getTargetClass(invocation), methodName, invocation.getArguments());
        }
        return this.beanDesc.invoke(target, methodName, invocation.getArguments());
    }
}

