/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.valid;

import java.util.HashMap;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.BaseValidator;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class StringValidator
extends BaseValidator {
    private int _minimumLength;
    private String _minimumLengthMessage;
    private String _scriptPath = "/org/apache/tapestry/valid/StringValidator.script";

    public StringValidator() {
    }

    private StringValidator(boolean required) {
        super(required);
    }

    public String toString(IFormComponent field, Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Object toObject(IFormComponent field, String input) throws ValidatorException {
        if (this.checkRequired(field, input)) {
            return null;
        }
        if (this._minimumLength > 0 && input.length() < this._minimumLength) {
            throw new ValidatorException(this.buildMinimumLengthMessage(field), ValidationConstraint.MINIMUM_WIDTH);
        }
        return input;
    }

    public int getMinimumLength() {
        return this._minimumLength;
    }

    public void setMinimumLength(int minimumLength) {
        this._minimumLength = minimumLength;
    }

    public void renderValidatorContribution(IFormComponent field, IMarkupWriter writer, IRequestCycle cycle) {
        if (!this.isClientScriptingEnabled()) {
            return;
        }
        if (!this.isRequired() && this._minimumLength <= 0) {
            return;
        }
        HashMap<String, String> symbols = new HashMap<String, String>();
        if (this.isRequired()) {
            symbols.put("requiredMessage", this.buildRequiredMessage(field));
        }
        if (this._minimumLength > 0) {
            symbols.put("minimumLengthMessage", this.buildMinimumLengthMessage(field));
        }
        this.processValidatorScript(this._scriptPath, cycle, field, symbols);
    }

    public String getScriptPath() {
        return this._scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this._scriptPath = scriptPath;
    }

    public String getMinimumLengthMessage() {
        return this._minimumLengthMessage;
    }

    public void setMinimumLengthMessage(String string) {
        this._minimumLengthMessage = string;
    }

    protected String buildMinimumLengthMessage(IFormComponent field) {
        String pattern = this.getPattern(this._minimumLengthMessage, "field-too-short", field.getPage().getLocale());
        return this.formatString(pattern, Integer.toString(this._minimumLength), field.getDisplayName());
    }
}

