/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.net.MalformedURLException;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.apache.tapestry.util.LocalizedNameGenerator;
import org.apache.tapestry.util.LocalizedResource;

public class LocalizedContextResourceFinder {
    private ServletContext _context;

    public LocalizedContextResourceFinder(ServletContext context) {
        this._context = context;
    }

    public LocalizedResource resolve(String contextPath, Locale locale) {
        int dotx = contextPath.lastIndexOf(46);
        String basePath = contextPath.substring(0, dotx);
        String suffix = contextPath.substring(dotx);
        LocalizedNameGenerator generator = new LocalizedNameGenerator(basePath, locale, suffix);
        while (generator.more()) {
            String candidatePath = generator.next();
            if (!this.isExistingResource(candidatePath)) continue;
            return new LocalizedResource(candidatePath, generator.getCurrentLocale());
        }
        return null;
    }

    private boolean isExistingResource(String path) {
        try {
            return this._context.getResource(path) != null;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }
}

