/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.pageload;

import java.util.Map;
import ognl.ClassResolver;
import ognl.Ognl;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.util.prop.OgnlUtils;

public class PropertyInitializer
implements PageDetachListener {
    private IResourceResolver _resolver;
    private IComponent _component;
    private String _propertyName;
    private String _expression;
    private boolean _invariant;
    private Object _value;
    private ILocation _location;

    public PropertyInitializer(IResourceResolver resolver, IComponent component, String propertyName, String expression, ILocation location) {
        this._resolver = resolver;
        this._component = component;
        this._propertyName = propertyName;
        this._expression = expression;
        this._location = location;
        this.prepareInvariant();
    }

    public void prepareInvariant() {
        this._invariant = false;
        try {
            if (Tapestry.isBlank(this._expression)) {
                this._invariant = true;
                this._value = OgnlUtils.get(this._propertyName, (ClassResolver)this._resolver, (Object)this._component);
            } else if (Ognl.isConstant((String)this._expression, (Map)Ognl.createDefaultContext((Object)this._component, (ClassResolver)this._resolver))) {
                this._invariant = true;
                this._value = OgnlUtils.get(this._expression, (ClassResolver)this._resolver, (Object)this._component);
            }
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.format("PageLoader.unable-to-initialize-property", this._propertyName, this._component, ex.getMessage()), this._location, ex);
        }
    }

    public void pageDetached(PageEvent event) {
        try {
            if (this._invariant) {
                OgnlUtils.set(this._propertyName, (ClassResolver)this._resolver, (Object)this._component, this._value);
            } else {
                Object value = OgnlUtils.get(this._expression, (ClassResolver)this._resolver, (Object)this._component);
                OgnlUtils.set(this._propertyName, (ClassResolver)this._resolver, (Object)this._component, value);
            }
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.format("PageLoader.unable-to-initialize-property", this._propertyName, this._component, ex.getMessage()), this._location, ex);
        }
    }
}

