/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.AbstractFormComponent;

public abstract class RadioGroup
extends AbstractFormComponent {
    private Object _selection;
    private int _selectedOption;
    private boolean _rewinding;
    private boolean _rendering;
    private int _nextOptionId;
    private static final String ATTRIBUTE_NAME = "org.apache.tapestry.active.RadioGroup";

    public static RadioGroup get(IRequestCycle cycle) {
        return (RadioGroup)cycle.getAttribute(ATTRIBUTE_NAME);
    }

    public abstract IBinding getSelectedBinding();

    public int getNextOptionId() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "nextOptionId");
        }
        return this._nextOptionId++;
    }

    public abstract boolean isDisabled();

    public boolean isRewinding() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "rewinding");
        }
        return this._rewinding;
    }

    public boolean isSelection(Object value) {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "selection");
        }
        if (this._selection == value) {
            return true;
        }
        if (this._selection == null || value == null) {
            return false;
        }
        return this._selection.equals(value);
    }

    public void updateSelection(Object value) {
        this.getSelectedBinding().setObject(value);
    }

    public boolean isSelected(int option) {
        return this._selectedOption == option;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = this.getForm(cycle);
        if (cycle.getAttribute(ATTRIBUTE_NAME) != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("RadioGroup.may-not-nest"), this, null, null);
        }
        this._rewinding = form.isRewinding();
        String name = form.getElementId(this);
        cycle.setAttribute(ATTRIBUTE_NAME, this);
        if (this._rewinding) {
            String value = cycle.getRequestContext().getParameter(name);
            this._selectedOption = value == null ? -1 : Integer.parseInt(value);
        }
        try {
            this._rendering = true;
            this._nextOptionId = 0;
            if (!this._rewinding) {
                this._selection = this.getSelectedBinding().getObject();
            }
            this.renderBody(writer, cycle);
        }
        finally {
            this._rendering = false;
            this._selection = null;
        }
        cycle.removeAttribute(ATTRIBUTE_NAME);
    }
}

