/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.enhance.IEnhancedClass;
import org.apache.tapestry.enhance.IEnhancedClassFactory;
import org.apache.tapestry.enhance.JavaClassMapping;
import org.apache.tapestry.enhance.NoOpEnhancer;
import org.apache.tapestry.spec.Direction;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IParameterSpecification;
import org.apache.tapestry.spec.IPropertySpecification;

public class ComponentClassFactory {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$enhance$ComponentClassFactory == null ? (class$org$apache$tapestry$enhance$ComponentClassFactory = ComponentClassFactory.class$("org.apache.tapestry.enhance.ComponentClassFactory")) : class$org$apache$tapestry$enhance$ComponentClassFactory));
    private static final String PACKAGE_PREFIX = "org.apache.tapestry.";
    private static int _uid = 0;
    private static Map _primitiveTypes = new HashMap();
    private IResourceResolver _resolver;
    private IEnhancedClassFactory _enhancedClassFactory;
    private IEnhancedClass _enhancedClass;
    private Map _beanProperties = new HashMap();
    private IComponentSpecification _specification;
    private Class _componentClass;
    private JavaClassMapping _classMapping = new JavaClassMapping();
    static /* synthetic */ Class class$org$apache$tapestry$enhance$ComponentClassFactory;
    static /* synthetic */ Class class$org$apache$tapestry$IBinding;

    public ComponentClassFactory(IResourceResolver resolver, IComponentSpecification specification, Class componentClass, IEnhancedClassFactory enhancedClassFactory) {
        this._resolver = resolver;
        this._specification = specification;
        this._componentClass = componentClass;
        this._enhancedClassFactory = enhancedClassFactory;
        this.buildBeanProperties();
    }

    private void buildBeanProperties() {
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(this._componentClass);
        }
        catch (IntrospectionException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("ComponentClassFactory.unable-to-introspect-class", this._componentClass.getName()), ex);
        }
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            this._beanProperties.put(descriptors[i].getName(), descriptors[i]);
        }
    }

    protected PropertyDescriptor getPropertyDescriptor(String name) {
        return (PropertyDescriptor)this._beanProperties.get(name);
    }

    public boolean needsEnhancement() {
        this.scanForEnhancements();
        return this._enhancedClass != null && this._enhancedClass.hasModifications();
    }

    public boolean isImplemented(PropertyDescriptor pd) {
        if (pd == null) {
            return false;
        }
        return this.isImplemented(pd.getReadMethod()) && this.isImplemented(pd.getWriteMethod());
    }

    public boolean isAbstract(Method m) {
        if (m == null) {
            return false;
        }
        return Modifier.isAbstract(m.getModifiers());
    }

    public boolean isImplemented(Method m) {
        if (m == null) {
            return false;
        }
        return !Modifier.isAbstract(m.getModifiers());
    }

    public Class convertPropertyType(String type, ILocation location) {
        Class result = this._classMapping.getType(type);
        if (result == null) {
            try {
                String typeName = this.translateClassName(type);
                result = this._resolver.findClass(typeName);
            }
            catch (Exception ex) {
                throw new ApplicationRuntimeException(Tapestry.format("ComponentClassFactory.bad-property-type", type), location, ex);
            }
            this._classMapping.recordType(type, result);
        }
        return result;
    }

    protected String translateClassName(String type) {
        if (!type.endsWith("[]")) {
            return type;
        }
        StringBuffer javaType = new StringBuffer();
        while (type.endsWith("[]")) {
            javaType.append("[");
            type = type.substring(0, type.length() - 2);
        }
        String primitiveIdentifier = (String)_primitiveTypes.get(type);
        if (primitiveIdentifier != null) {
            javaType.append(primitiveIdentifier);
        } else {
            javaType.append("L" + type + ";");
        }
        return javaType.toString();
    }

    protected void checkPropertyType(PropertyDescriptor pd, Class propertyType, ILocation location) {
        if (!pd.getPropertyType().equals(propertyType)) {
            throw new ApplicationRuntimeException(Tapestry.format("ComponentClassFactory.property-type-mismatch", new Object[]{this._componentClass.getName(), pd.getName(), pd.getPropertyType().getName(), propertyType.getName()}), location, null);
        }
    }

    protected String checkAccessors(String propertyName, Class propertyType, ILocation location) {
        PropertyDescriptor d = this.getPropertyDescriptor(propertyName);
        if (d == null) {
            return null;
        }
        this.checkPropertyType(d, propertyType, location);
        Method write = d.getWriteMethod();
        Method read = d.getReadMethod();
        if (this.isImplemented(write)) {
            throw new ApplicationRuntimeException(Tapestry.format("ComponentClassFactory.non-abstract-write", write.getDeclaringClass().getName(), propertyName), location, null);
        }
        if (this.isImplemented(read)) {
            throw new ApplicationRuntimeException(Tapestry.format("ComponentClassFactory.non-abstract-read", read.getDeclaringClass().getName(), propertyName), location, null);
        }
        return read == null ? null : read.getName();
    }

    protected boolean isMissingProperty(String propertyName) {
        PropertyDescriptor pd = this.getPropertyDescriptor(propertyName);
        return !this.isImplemented(pd);
    }

    public Class createEnhancedSubclass() {
        IEnhancedClass enhancedClass = this.getEnhancedClass();
        String startClassName = this._componentClass.getName();
        String subclassName = enhancedClass.getClassName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Enhancing subclass of " + startClassName + " for " + this._specification.getSpecificationLocation()));
        }
        Class result = enhancedClass.createEnhancedSubclass();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Finished creating enhanced class " + subclassName));
        }
        return result;
    }

    protected void scanForEnhancements() {
        this.scanForParameterEnhancements();
        this.scanForSpecifiedPropertyEnhancements();
        this.scanForAbstractClass();
    }

    protected void scanForAbstractClass() {
        if (Modifier.isAbstract(this._componentClass.getModifiers())) {
            this.getEnhancedClass().addEnhancer(new NoOpEnhancer());
        }
    }

    protected void scanForParameterEnhancements() {
        List names = this._specification.getParameterNames();
        int count = names.size();
        for (int i = 0; i < count; ++i) {
            String name = (String)names.get(i);
            IParameterSpecification ps = this._specification.getParameter(name);
            this.scanForBindingProperty(name, ps);
            this.scanForParameterProperty(name, ps);
        }
    }

    protected void scanForSpecifiedPropertyEnhancements() {
        List names = this._specification.getPropertySpecificationNames();
        int count = names.size();
        for (int i = 0; i < count; ++i) {
            String name = (String)names.get(i);
            IPropertySpecification ps = this._specification.getPropertySpecification(name);
            this.scanForSpecifiedProperty(ps);
        }
    }

    protected void scanForBindingProperty(String parameterName, IParameterSpecification ps) {
        String propertyName = parameterName + "Binding";
        PropertyDescriptor pd = this.getPropertyDescriptor(propertyName);
        if (ps.getDirection() == Direction.CUSTOM) {
            if (pd == null) {
                return;
            }
            if (!this.isAbstract(pd.getReadMethod()) && !this.isAbstract(pd.getWriteMethod())) {
                return;
            }
        }
        if (this.isImplemented(pd)) {
            return;
        }
        this.getEnhancedClass().createProperty(propertyName, (class$org$apache$tapestry$IBinding == null ? (class$org$apache$tapestry$IBinding = ComponentClassFactory.class$("org.apache.tapestry.IBinding")) : class$org$apache$tapestry$IBinding).getName());
    }

    protected void scanForParameterProperty(String parameterName, IParameterSpecification ps) {
        Direction direction = ps.getDirection();
        if (direction == Direction.CUSTOM) {
            return;
        }
        if (direction == Direction.AUTO) {
            this.addAutoParameterEnhancer(parameterName, ps);
            return;
        }
        String propertyName = ps.getPropertyName();
        if (!this.isMissingProperty(propertyName)) {
            return;
        }
        ILocation location = ps.getLocation();
        Class propertyType = this.convertPropertyType(ps.getType(), location);
        String readMethodName = this.checkAccessors(propertyName, propertyType, location);
        this.getEnhancedClass().createProperty(propertyName, ps.getType(), readMethodName, false);
    }

    protected void addAutoParameterEnhancer(String parameterName, IParameterSpecification ps) {
        ILocation location = ps.getLocation();
        String propertyName = ps.getPropertyName();
        if (!ps.isRequired() && ps.getDefaultValue() == null) {
            throw new ApplicationRuntimeException(Tapestry.format("ComponentClassFactory.auto-must-be-required", parameterName), location, null);
        }
        Class propertyType = this.convertPropertyType(ps.getType(), location);
        String readMethodName = this.checkAccessors(propertyName, propertyType, location);
        this.getEnhancedClass().createAutoParameter(propertyName, parameterName, ps.getType(), readMethodName);
    }

    protected void scanForSpecifiedProperty(IPropertySpecification ps) {
        String propertyName = ps.getName();
        ILocation location = ps.getLocation();
        Class propertyType = this.convertPropertyType(ps.getType(), location);
        PropertyDescriptor pd = this.getPropertyDescriptor(propertyName);
        if (this.isImplemented(pd)) {
            this.checkPropertyType(pd, propertyType, location);
            return;
        }
        String readMethodName = this.checkAccessors(propertyName, propertyType, location);
        this.getEnhancedClass().createProperty(propertyName, ps.getType(), readMethodName, ps.isPersistent());
    }

    public IEnhancedClass getEnhancedClass() {
        if (this._enhancedClass == null) {
            String startClassName = this._componentClass.getName();
            String subclassName = startClassName + "$Enhance_" + ComponentClassFactory.generateUID();
            if (subclassName.startsWith("java.") || subclassName.startsWith("javax.")) {
                subclassName = PACKAGE_PREFIX + subclassName;
            }
            this._enhancedClass = this._enhancedClassFactory.createEnhancedClass(subclassName, this._componentClass);
        }
        return this._enhancedClass;
    }

    private static synchronized int generateUID() {
        return _uid++;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _primitiveTypes.put("boolean", "Z");
        _primitiveTypes.put("short", "S");
        _primitiveTypes.put("int", "I");
        _primitiveTypes.put("long", "J");
        _primitiveTypes.put("float", "F");
        _primitiveTypes.put("double", "D");
        _primitiveTypes.put("char", "C");
        _primitiveTypes.put("byte", "B");
    }
}

