/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.binding;

import java.lang.reflect.Field;
import org.apache.tapestry.BindingException;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.binding.AbstractBinding;

public class FieldBinding
extends AbstractBinding {
    private String fieldName;
    private boolean accessed;
    private Object value;
    private IResourceResolver resolver;

    public FieldBinding(IResourceResolver resolver, String fieldName, ILocation location) {
        super(location);
        this.resolver = resolver;
        this.fieldName = fieldName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("FieldBinding[");
        buffer.append(this.fieldName);
        if (this.accessed) {
            buffer.append(" (");
            buffer.append(this.value);
            buffer.append(')');
        }
        buffer.append(']');
        return buffer.toString();
    }

    public Object getObject() {
        if (!this.accessed) {
            this.accessValue();
        }
        return this.value;
    }

    private void accessValue() {
        Field field;
        Class targetClass;
        int dotx = this.fieldName.lastIndexOf(46);
        if (dotx < 0) {
            throw new BindingException(Tapestry.format("invalid-field-name", this.fieldName), this);
        }
        String className = this.fieldName.substring(0, dotx);
        String simpleFieldName = this.fieldName.substring(dotx + 1);
        if (className.indexOf(46) < 0) {
            className = "java.lang." + className;
        }
        try {
            targetClass = this.resolver.findClass(className);
        }
        catch (Throwable t) {
            throw new BindingException(Tapestry.format("unable-to-resolve-class", className), this, t);
        }
        try {
            field = targetClass.getField(simpleFieldName);
        }
        catch (NoSuchFieldException ex) {
            throw new BindingException(Tapestry.format("field-not-defined", this.fieldName), this, (Throwable)ex);
        }
        try {
            this.value = field.get(null);
        }
        catch (IllegalAccessException ex) {
            throw new BindingException(Tapestry.format("illegal-field-acccess", this.fieldName), this, (Throwable)ex);
        }
        catch (NullPointerException ex) {
            throw new BindingException(Tapestry.format("field-is-instance", this.fieldName), this, (Throwable)ex);
        }
        this.accessed = true;
    }
}

