/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.tapestry.util;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.tapestry.util.AccessaUtil;

public class InjectionUtil {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$tapestry$page$translation$BeanCopy == null ? (class$org$seasar$tapestry$page$translation$BeanCopy = InjectionUtil.class$("org.seasar.tapestry.page.translation.BeanCopy")) : class$org$seasar$tapestry$page$translation$BeanCopy));
    static /* synthetic */ Class class$org$seasar$tapestry$page$translation$BeanCopy;

    InjectionUtil() {
    }

    public static void invokeSetterInjection(Object object) {
        S2Container s2Container = SingletonS2ContainerFactory.getContainer().getRoot();
        Method[] methodArray = object.getClass().getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!InjectionUtil.isInjectionableMethod(s2Container, method)) continue;
            InjectionUtil.doInjection(s2Container, object, method);
        }
    }

    public static void invokeSetterInjection(Class clazz, Object object) {
        S2Container s2Container = SingletonS2ContainerFactory.getContainer().getRoot();
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!InjectionUtil.isInjectionableMethod(s2Container, method)) continue;
            InjectionUtil.doInjection(s2Container, object, method);
        }
    }

    private static void doInjection(S2Container s2Container, Object object, Method method) {
        try {
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz = classArray[0];
            Object object2 = s2Container.getComponent(clazz);
            if (object2 == null) {
                return;
            }
            method.invoke(object, object2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Injection : " + method.getName() + "(" + object2.getClass().getName() + "::" + object2.toString() + ")"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isInjectionableMethod(S2Container s2Container, Method method) {
        if (!AccessaUtil.isSetterMethod(method)) {
            return false;
        }
        Class<?>[] classArray = method.getParameterTypes();
        Class<?> clazz = classArray[0];
        if (clazz.isPrimitive()) {
            return false;
        }
        return s2Container.hasComponentDef(clazz);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

