/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.tapestry.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.asset.ContextAsset;
import org.apache.tapestry.asset.ExternalAsset;
import org.apache.tapestry.asset.PrivateAsset;
import org.apache.tapestry.binding.ExpressionBinding;
import org.apache.tapestry.binding.FieldBinding;
import org.apache.tapestry.binding.ListenerBinding;
import org.apache.tapestry.binding.StaticBinding;
import org.apache.tapestry.binding.StringBinding;
import org.apache.tapestry.engine.IComponentClassEnhancer;
import org.apache.tapestry.engine.IPageLoader;
import org.apache.tapestry.engine.ISpecificationSource;
import org.apache.tapestry.engine.ITemplateSource;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.pageload.ComponentTreeWalker;
import org.apache.tapestry.pageload.EstablishDefaultParameterValuesVisitor;
import org.apache.tapestry.pageload.IComponentVisitor;
import org.apache.tapestry.pageload.PropertyInitializer;
import org.apache.tapestry.pageload.VerifyRequiredParametersVisitor;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.resolver.ComponentSpecificationResolver;
import org.apache.tapestry.resource.ClasspathResourceLocation;
import org.apache.tapestry.resource.ContextResourceLocation;
import org.apache.tapestry.spec.AssetType;
import org.apache.tapestry.spec.BindingType;
import org.apache.tapestry.spec.IAssetSpecification;
import org.apache.tapestry.spec.IBindingSpecification;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IContainedComponent;
import org.apache.tapestry.spec.IListenerBindingSpecification;
import org.apache.tapestry.spec.IPropertySpecification;

public abstract class CopyOfPageLoader
implements IPageLoader {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$tapestry$engine$CopyOfPageLoader == null ? (class$org$seasar$tapestry$engine$CopyOfPageLoader = CopyOfPageLoader.class$("org.seasar.tapestry.engine.CopyOfPageLoader")) : class$org$seasar$tapestry$engine$CopyOfPageLoader));
    private IEngine _engine;
    private IResourceResolver _resolver;
    private IComponentClassEnhancer _enhancer;
    private ISpecificationSource _specificationSource;
    private ComponentSpecificationResolver _componentResolver;
    private List _inheritedBindingQueue = new ArrayList();
    private List _propertyInitializers = new ArrayList();
    private ComponentTreeWalker _establishDefaultParameterValuesWalker;
    private ComponentTreeWalker _verifyRequiredParametersWalker;
    private Locale _locale;
    private int _count;
    private int _depth;
    private int _maxDepth;
    private IResourceLocation _servletLocation;
    static /* synthetic */ Class class$org$seasar$tapestry$engine$CopyOfPageLoader;
    static /* synthetic */ Class class$org$apache$tapestry$BaseComponent;

    private IPage instantiatePage(String string, INamespace iNamespace, IComponentSpecification iComponentSpecification) {
        IPage iPage = null;
        String string2 = iNamespace.constructQualifiedName(string);
        String string3 = iComponentSpecification.getComponentClassName();
        ILocation iLocation = iComponentSpecification.getLocation();
        if (Tapestry.isBlank((String)string3)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Page " + iNamespace.constructQualifiedName(string) + " does not specify a component class."));
            }
            if ((string3 = this._engine.getPropertySource().getPropertyValue("org.apache.tapestry.default-page-class")) == null) {
                string3 = this.getDefaultPage();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Defaulting to class " + string3));
            }
        }
        Class clazz = this._enhancer.getEnhancedClass(iComponentSpecification, string3);
        String string4 = clazz.getName();
        try {
            iPage = this.getPageComponent(clazz);
            iPage.setNamespace(iNamespace);
            iPage.setSpecification(iComponentSpecification);
            iPage.setPageName(string2);
            iPage.setPage(iPage);
            iPage.setLocale(this._locale);
            iPage.setLocation(iLocation);
        }
        catch (ClassCastException classCastException) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.class-not-page", (Object)string4), iLocation, (Throwable)classCastException);
        }
        catch (Exception exception) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.unable-to-instantiate", (Object)string4), iLocation, (Throwable)exception);
        }
        return iPage;
    }

    public abstract String getDefaultPage();

    public abstract IPage getPageComponent(Class var1) throws Exception;

    public CopyOfPageLoader(IRequestCycle iRequestCycle) {
        IEngine iEngine = iRequestCycle.getEngine();
        this._specificationSource = iEngine.getSpecificationSource();
        this._resolver = iEngine.getResourceResolver();
        this._enhancer = iEngine.getComponentClassEnhancer();
        this._componentResolver = new ComponentSpecificationResolver(iRequestCycle);
        RequestContext requestContext = iRequestCycle.getRequestContext();
        HttpServletRequest httpServletRequest = requestContext.getRequest();
        String string = httpServletRequest.getServletPath();
        this._servletLocation = new ContextResourceLocation(requestContext.getServlet().getServletContext(), string);
        VerifyRequiredParametersVisitor verifyRequiredParametersVisitor = new VerifyRequiredParametersVisitor();
        this._verifyRequiredParametersWalker = new ComponentTreeWalker(new IComponentVisitor[]{verifyRequiredParametersVisitor});
        EstablishDefaultParameterValuesVisitor establishDefaultParameterValuesVisitor = new EstablishDefaultParameterValuesVisitor(this._resolver);
        this._establishDefaultParameterValuesWalker = new ComponentTreeWalker(new IComponentVisitor[]{establishDefaultParameterValuesVisitor});
    }

    private void bind(IComponent iComponent, IComponent iComponent2, IContainedComponent iContainedComponent) {
        Object object;
        boolean bl;
        IComponentSpecification iComponentSpecification = iComponent2.getSpecification();
        boolean bl2 = !iComponentSpecification.getAllowInformalParameters();
        IComponentSpecification iComponentSpecification2 = iComponent.getSpecification();
        boolean bl3 = bl = !iComponentSpecification2.getAllowInformalParameters();
        if (iContainedComponent.getInheritInformalParameters()) {
            if (bl2) {
                throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.inherit-informal-invalid-component-formal-only", (Object)iComponent2.getExtendedId()), (Object)iComponent2, iContainedComponent.getLocation(), null);
            }
            if (bl) {
                throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.inherit-informal-invalid-container-formal-only", (Object)iComponent.getExtendedId(), (Object)iComponent2.getExtendedId()), (Object)iComponent2, iContainedComponent.getLocation(), null);
            }
            object = new QueuedInheritInformalBindings(iComponent2);
            this._inheritedBindingQueue.add(object);
        }
        object = iContainedComponent.getBindingNames().iterator();
        while (object.hasNext()) {
            Object object2;
            String string = (String)object.next();
            boolean bl4 = iComponentSpecification.getParameter(string) != null;
            IBindingSpecification iBindingSpecification = iContainedComponent.getBinding(string);
            if (bl2 && !bl4) {
                throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.formal-parameters-only", (Object)iComponent2.getExtendedId(), (Object)string), (Object)iComponent2, iBindingSpecification.getLocation(), null);
            }
            if (!bl4 && iComponentSpecification.isReservedParameterName(string)) continue;
            BindingType bindingType = iBindingSpecification.getType();
            if (bindingType == BindingType.INHERITED) {
                object2 = new QueuedInheritedBinding(iComponent2, iBindingSpecification.getValue(), string);
                this._inheritedBindingQueue.add(object2);
                continue;
            }
            if (bindingType == BindingType.LISTENER) {
                this.constructListenerBinding(iComponent2, string, (IListenerBindingSpecification)iBindingSpecification);
                continue;
            }
            object2 = this.convert(iComponent, iBindingSpecification);
            if (object2 == null) continue;
            iComponent2.setBinding(string, object2);
        }
    }

    private IBinding convert(IComponent iComponent, IBindingSpecification iBindingSpecification) {
        BindingType bindingType = iBindingSpecification.getType();
        ILocation iLocation = iBindingSpecification.getLocation();
        String string = iBindingSpecification.getValue();
        if (bindingType == BindingType.DYNAMIC) {
            return new ExpressionBinding(this._resolver, iComponent, string, iLocation);
        }
        if (bindingType == BindingType.STRING) {
            return new StringBinding(iComponent, string, iLocation);
        }
        if (bindingType == BindingType.STATIC) {
            return new StaticBinding(string, iLocation);
        }
        if (bindingType == BindingType.FIELD) {
            return new FieldBinding(this._resolver, string, iLocation);
        }
        throw new ApplicationRuntimeException("Unexpected type: " + bindingType + ".");
    }

    private void constructListenerBinding(IComponent iComponent, String string, IListenerBindingSpecification iListenerBindingSpecification) {
        String string2 = iListenerBindingSpecification.getLanguage();
        if (Tapestry.isBlank((String)string2)) {
            string2 = this._engine.getPropertySource().getPropertyValue("org.apache.tapestry.default-script-language");
        }
        ListenerBinding listenerBinding = new ListenerBinding(iComponent.getContainer(), string2, iListenerBindingSpecification.getScript(), iListenerBindingSpecification.getLocation());
        iComponent.setBinding(string, (IBinding)listenerBinding);
    }

    private void constructComponent(IRequestCycle iRequestCycle, IPage iPage, IComponent iComponent, IComponentSpecification iComponentSpecification, INamespace iNamespace) {
        ++this._depth;
        if (this._depth > this._maxDepth) {
            this._maxDepth = this._depth;
        }
        ArrayList arrayList = new ArrayList(iComponentSpecification.getComponentIds());
        int n = arrayList.size();
        try {
            for (int i = 0; i < n; ++i) {
                String string = (String)arrayList.get(i);
                IContainedComponent iContainedComponent = iComponentSpecification.getComponent(string);
                String string2 = iContainedComponent.getType();
                ILocation iLocation = iContainedComponent.getLocation();
                this._componentResolver.resolve(iRequestCycle, iNamespace, string2, iLocation);
                IComponentSpecification iComponentSpecification2 = this._componentResolver.getSpecification();
                INamespace iNamespace2 = this._componentResolver.getNamespace();
                IComponent iComponent2 = this.instantiateComponent(iPage, iComponent, string, iComponentSpecification2, iNamespace2, iLocation);
                iComponent.addComponent(iComponent2);
                this.bind(iComponent, iComponent2, iContainedComponent);
                this.constructComponent(iRequestCycle, iPage, iComponent2, iComponentSpecification2, iNamespace2);
            }
            this.addAssets(iComponent, iComponentSpecification);
            iComponent.finishLoad(iRequestCycle, (IPageLoader)this, iComponentSpecification);
            this.createPropertyInitializers(iPage, iComponent, iComponentSpecification);
        }
        catch (ApplicationRuntimeException applicationRuntimeException) {
            throw applicationRuntimeException;
        }
        catch (RuntimeException runtimeException) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.unable-to-instantiate-component", (Object)iComponent.getExtendedId(), (Object)runtimeException.getMessage()), (Object)iComponent, null, (Throwable)runtimeException);
        }
        --this._depth;
    }

    public IComponent createImplicitComponent(IRequestCycle iRequestCycle, IComponent iComponent, String string, String string2, ILocation iLocation) {
        IPage iPage = iComponent.getPage();
        this._componentResolver.resolve(iRequestCycle, iComponent.getNamespace(), string2, iLocation);
        INamespace iNamespace = this._componentResolver.getNamespace();
        IComponentSpecification iComponentSpecification = this._componentResolver.getSpecification();
        IComponent iComponent2 = this.instantiateComponent(iPage, iComponent, string, iComponentSpecification, iNamespace, iLocation);
        iComponent.addComponent(iComponent2);
        this.constructComponent(iRequestCycle, iPage, iComponent2, iComponentSpecification, iNamespace);
        return iComponent2;
    }

    private IComponent instantiateComponent(IPage iPage, IComponent iComponent, String string, IComponentSpecification iComponentSpecification, INamespace iNamespace, ILocation iLocation) {
        IComponent iComponent2 = null;
        String string2 = iComponentSpecification.getComponentClassName();
        if (Tapestry.isBlank((String)string2)) {
            string2 = (class$org$apache$tapestry$BaseComponent == null ? (class$org$apache$tapestry$BaseComponent = CopyOfPageLoader.class$("org.apache.tapestry.BaseComponent")) : class$org$apache$tapestry$BaseComponent).getName();
        }
        Class clazz = this._enhancer.getEnhancedClass(iComponentSpecification, string2);
        String string3 = clazz.getName();
        try {
            iComponent2 = (IComponent)clazz.newInstance();
        }
        catch (ClassCastException classCastException) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.class-not-component", (Object)string3), (Object)iComponent, iComponentSpecification.getLocation(), (Throwable)classCastException);
        }
        catch (Throwable throwable) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.unable-to-instantiate", (Object)string3), (Object)iComponent, iComponentSpecification.getLocation(), throwable);
        }
        if (iComponent2 instanceof IPage) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.page-not-allowed", (Object)iComponent2.getExtendedId()), (Object)iComponent2, null, null);
        }
        iComponent2.setNamespace(iNamespace);
        iComponent2.setSpecification(iComponentSpecification);
        iComponent2.setPage(iPage);
        iComponent2.setContainer(iComponent);
        iComponent2.setId(string);
        iComponent2.setLocation(iLocation);
        ++this._count;
        return iComponent2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPage loadPage(String string, INamespace iNamespace, IRequestCycle iRequestCycle, IComponentSpecification iComponentSpecification) {
        IPage iPage = null;
        this._engine = iRequestCycle.getEngine();
        this._locale = this._engine.getLocale();
        this._count = 0;
        this._depth = 0;
        this._maxDepth = 0;
        try {
            iPage = this.instantiatePage(string, iNamespace, iComponentSpecification);
            iPage.attach(this._engine);
            iPage.setRequestCycle(iRequestCycle);
            this.constructComponent(iRequestCycle, iPage, (IComponent)iPage, iComponentSpecification, iNamespace);
            this._establishDefaultParameterValuesWalker.walkComponentTree((IComponent)iPage);
            this.establishInheritedBindings();
            this._verifyRequiredParametersWalker.walkComponentTree((IComponent)iPage);
            this.establishDefaultPropertyValues();
            Object var7_6 = null;
            this._locale = null;
            this._engine = null;
            this._inheritedBindingQueue.clear();
            this._propertyInitializers.clear();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this._locale = null;
            this._engine = null;
            this._inheritedBindingQueue.clear();
            this._propertyInitializers.clear();
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loaded page " + iPage + " with " + this._count + " components (maximum depth " + this._maxDepth + ")"));
        }
        return iPage;
    }

    private void establishInheritedBindings() {
        LOG.debug((Object)"Establishing inherited bindings");
        int n = this._inheritedBindingQueue.size();
        for (int i = 0; i < n; ++i) {
            IQueuedInheritedBinding iQueuedInheritedBinding = (IQueuedInheritedBinding)this._inheritedBindingQueue.get(i);
            iQueuedInheritedBinding.connect();
        }
    }

    private void establishDefaultPropertyValues() {
        LOG.debug((Object)"Setting default property values");
        int n = this._propertyInitializers.size();
        for (int i = 0; i < n; ++i) {
            PageDetachListener pageDetachListener = (PageDetachListener)this._propertyInitializers.get(i);
            pageDetachListener.pageDetached(null);
        }
    }

    private void addAssets(IComponent iComponent, IComponentSpecification iComponentSpecification) {
        List list = iComponentSpecification.getAssetNames();
        if (list.isEmpty()) {
            return;
        }
        IResourceLocation iResourceLocation = iComponentSpecification.getSpecificationLocation();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            IAssetSpecification iAssetSpecification = iComponentSpecification.getAsset(string);
            IAsset iAsset = this.convert(string, iComponent, iAssetSpecification, iResourceLocation);
            iComponent.addAsset(string, iAsset);
        }
    }

    private void createPropertyInitializers(IPage iPage, IComponent iComponent, IComponentSpecification iComponentSpecification) {
        List list = iComponentSpecification.getPropertySpecificationNames();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            IPropertySpecification iPropertySpecification = iComponentSpecification.getPropertySpecification(string);
            String string2 = iPropertySpecification.getInitialValue();
            PropertyInitializer propertyInitializer = new PropertyInitializer(this._resolver, iComponent, string, string2, iPropertySpecification.getLocation());
            this._propertyInitializers.add(propertyInitializer);
            iPage.addPageDetachListener((PageDetachListener)propertyInitializer);
        }
    }

    private IAsset convert(String string, IComponent iComponent, IAssetSpecification iAssetSpecification, IResourceLocation iResourceLocation) {
        AssetType assetType = iAssetSpecification.getType();
        String string2 = iAssetSpecification.getPath();
        ILocation iLocation = iAssetSpecification.getLocation();
        if (assetType == AssetType.EXTERNAL) {
            return new ExternalAsset(string2, iLocation);
        }
        if (assetType == AssetType.PRIVATE) {
            IResourceLocation iResourceLocation2 = iResourceLocation;
            if (string2.startsWith("/")) {
                iResourceLocation2 = new ClasspathResourceLocation(this._resolver, "/");
                string2 = string2.substring(1);
            }
            return new PrivateAsset((ClasspathResourceLocation)this.findAsset(string, iComponent, iResourceLocation2, string2, iLocation), iLocation);
        }
        return new ContextAsset((ContextResourceLocation)this.findAsset(string, iComponent, this._servletLocation, string2, iLocation), iLocation);
    }

    private IResourceLocation findAsset(String string, IComponent iComponent, IResourceLocation iResourceLocation, String string2, ILocation iLocation) {
        IResourceLocation iResourceLocation2 = iResourceLocation.getRelativeLocation(string2);
        IResourceLocation iResourceLocation3 = iResourceLocation2.getLocalization(this._locale);
        if (iResourceLocation3 == null) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.missing-asset", (Object)string, (Object)iComponent.getExtendedId(), (Object)iResourceLocation2), (Object)iComponent, iLocation, null);
        }
        return iResourceLocation3;
    }

    public IEngine getEngine() {
        return this._engine;
    }

    public ITemplateSource getTemplateSource() {
        return this._engine.getTemplateSource();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class QueuedInheritInformalBindings
    implements IQueuedInheritedBinding {
        private IComponent _component;

        private QueuedInheritInformalBindings(IComponent iComponent) {
            this._component = iComponent;
        }

        public void connect() {
            IComponent iComponent = this._component.getContainer();
            Iterator iterator = iComponent.getBindingNames().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.connectInformalBinding(iComponent, this._component, string);
            }
        }

        private void connectInformalBinding(IComponent iComponent, IComponent iComponent2, String string) {
            IComponentSpecification iComponentSpecification = iComponent2.getSpecification();
            IComponentSpecification iComponentSpecification2 = iComponent.getSpecification();
            if (iComponent2.getBinding(string) != null) {
                return;
            }
            if (iComponentSpecification.getParameter(string) != null || iComponentSpecification.isReservedParameterName(string)) {
                return;
            }
            if (iComponentSpecification2.getParameter(string) != null || iComponentSpecification2.isReservedParameterName(string)) {
                return;
            }
            IBinding iBinding = iComponent.getBinding(string);
            iComponent2.setBinding(string, iBinding);
        }
    }

    private static class QueuedInheritedBinding
    implements IQueuedInheritedBinding {
        private IComponent _component;
        private String _containerParameterName;
        private String _parameterName;

        private QueuedInheritedBinding(IComponent iComponent, String string, String string2) {
            this._component = iComponent;
            this._containerParameterName = string;
            this._parameterName = string2;
        }

        public void connect() {
            IBinding iBinding = this._component.getContainer().getBinding(this._containerParameterName);
            if (iBinding == null) {
                return;
            }
            this._component.setBinding(this._parameterName, iBinding);
        }
    }

    private static interface IQueuedInheritedBinding {
        public void connect();
    }
}

