/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.model.common;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.components.Block;
import org.apache.tapestry.contrib.table.model.ITableColumn;
import org.apache.tapestry.contrib.table.model.ITableModelSource;
import org.apache.tapestry.contrib.table.model.ITableRendererSource;
import org.apache.tapestry.contrib.table.model.common.BlockTableRendererSource;
import org.apache.tapestry.valid.RenderString;

public class AbstractTableColumn
implements ITableColumn,
Serializable {
    public static final String COLUMN_RENDERER_BLOCK_SUFFIX = "ColumnHeader";
    public static final String VALUE_RENDERER_BLOCK_SUFFIX = "ColumnValue";
    private String m_strColumnName;
    private boolean m_bSortable;
    private Comparator m_objComparator;
    private ITableRendererSource m_objColumnRendererSource;
    private ITableRendererSource m_objValueRendererSource;

    public AbstractTableColumn() {
        this("", false, null);
    }

    public AbstractTableColumn(String strColumnName, boolean bSortable, Comparator objComparator) {
        this(strColumnName, bSortable, objComparator, null, null);
    }

    public AbstractTableColumn(String strColumnName, boolean bSortable, Comparator objComparator, ITableRendererSource objColumnRendererSource, ITableRendererSource objValueRendererSource) {
        this.setColumnName(strColumnName);
        this.setSortable(bSortable);
        this.setComparator(objComparator);
        this.setColumnRendererSource(objColumnRendererSource);
        this.setValueRendererSource(objValueRendererSource);
    }

    public String getColumnName() {
        return this.m_strColumnName;
    }

    public void setColumnName(String columnName) {
        this.m_strColumnName = columnName;
    }

    public boolean getSortable() {
        return this.m_bSortable;
    }

    public void setSortable(boolean sortable) {
        this.m_bSortable = sortable;
    }

    public Comparator getComparator() {
        return this.m_objComparator;
    }

    public void setComparator(Comparator comparator) {
        this.m_objComparator = comparator;
    }

    public IRender getColumnRenderer(IRequestCycle objCycle, ITableModelSource objSource) {
        ITableRendererSource objRendererSource = this.getColumnRendererSource();
        if (objRendererSource == null) {
            return new RenderString("");
        }
        return objRendererSource.getRenderer(objCycle, objSource, this, null);
    }

    public IRender getValueRenderer(IRequestCycle objCycle, ITableModelSource objSource, Object objRow) {
        ITableRendererSource objRendererSource = this.getValueRendererSource();
        if (objRendererSource == null) {
            return new RenderString("");
        }
        return objRendererSource.getRenderer(objCycle, objSource, this, objRow);
    }

    public ITableRendererSource getColumnRendererSource() {
        return this.m_objColumnRendererSource;
    }

    public void setColumnRendererSource(ITableRendererSource columnRendererSource) {
        this.m_objColumnRendererSource = columnRendererSource;
    }

    public ITableRendererSource getValueRendererSource() {
        return this.m_objValueRendererSource;
    }

    public void setValueRendererSource(ITableRendererSource valueRendererSource) {
        this.m_objValueRendererSource = valueRendererSource;
    }

    public void loadSettings(IComponent objSettingsContainer) {
        IComponent objValueRendererSource;
        IComponent objColumnRendererSource = (IComponent)objSettingsContainer.getComponents().get(this.getColumnName() + COLUMN_RENDERER_BLOCK_SUFFIX);
        if (objColumnRendererSource != null && objColumnRendererSource instanceof Block) {
            this.setColumnRendererSource(new BlockTableRendererSource((Block)objColumnRendererSource));
        }
        if ((objValueRendererSource = (IComponent)objSettingsContainer.getComponents().get(this.getColumnName() + VALUE_RENDERER_BLOCK_SUFFIX)) != null && objValueRendererSource instanceof Block) {
            this.setValueRendererSource(new BlockTableRendererSource((Block)objValueRendererSource));
        }
    }
}

