/*
 * Created on 2004/10/28
 */
package org.seasar.tapestry.service;

import java.util.HashSet;
import java.util.Set;

import org.apache.tapestry.engine.IEngineService;
import org.seasar.tapestry.pageinjection.Injection;
import org.seasar.tapestry.pageinjection.impl.ExtentionClassInjection;

/**
 * @author maruo_syunsuke
 */
public class InjectionForEngineService_Basic implements InjectionForEngineService{
	private Set initializingServiceFlag_ = new HashSet();

	private boolean isAlreadyDI(String name) {
		return this.initializingServiceFlag_.contains(name);
	}

	private void checkFlag(String name) {
		this.initializingServiceFlag_.add(name);
	}

	public void invoke(IEngineService service) {
		String name = service.getName();
		if (isAlreadyDI(name) == false) {
			Injection injection = new ExtentionClassInjection();
			injection.invoke(service);
			checkFlag(name);
		}
	}
}
