/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.popup;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.Tapestry;

public class PopupLink
extends BaseComponent {
    public static final String DEFAULT_WINDOW_NAME = "popuplink_window";
    private static final URLCodec _urlCodec = new URLCodec();
    private IBinding _hrefBinding;
    private IBinding _windowNameBinding;
    private IBinding _featuresBinding;

    public IBinding getHrefBinding() {
        return this._hrefBinding;
    }

    public void setHrefBinding(IBinding hrefBinding) {
        this._hrefBinding = hrefBinding;
    }

    public IBinding getWindowNameBinding() {
        return this._windowNameBinding;
    }

    public void setWindowNameBinding(IBinding windowNameBinding) {
        this._windowNameBinding = windowNameBinding;
    }

    public IBinding getFeaturesBinding() {
        return this._featuresBinding;
    }

    public void setFeaturesBinding(IBinding featuresBinding) {
        this._featuresBinding = featuresBinding;
    }

    public String getHref() {
        IBinding aHrefBinding = this.getHrefBinding();
        if (aHrefBinding != null) {
            String encoding = this.getPage().getEngine().getOutputEncoding();
            try {
                return _urlCodec.encode(aHrefBinding.getString(), encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ApplicationRuntimeException(Tapestry.format((String)"illegal-encoding", (Object)encoding), (Throwable)e);
            }
        }
        return null;
    }

    public String getWindowName() {
        IBinding aWindowNameBinding = this.getWindowNameBinding();
        if (aWindowNameBinding != null) {
            return aWindowNameBinding.getString();
        }
        return DEFAULT_WINDOW_NAME;
    }

    public String getFeatures() {
        IBinding aFeaturesBinding = this.getFeaturesBinding();
        if (aFeaturesBinding != null) {
            return aFeaturesBinding.getString();
        }
        return "";
    }

    public String getPopupFunctionName() {
        return this.getIdPath().replace('.', '_') + "_popup";
    }
}

