/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.io;

import java.io.IOException;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.util.AdaptorRegistry;
import org.apache.tapestry.util.io.BooleanAdaptor;
import org.apache.tapestry.util.io.ByteAdaptor;
import org.apache.tapestry.util.io.CharacterAdaptor;
import org.apache.tapestry.util.io.ComponentAddressAdaptor;
import org.apache.tapestry.util.io.DoubleAdaptor;
import org.apache.tapestry.util.io.EnumAdaptor;
import org.apache.tapestry.util.io.FloatAdaptor;
import org.apache.tapestry.util.io.ISqueezeAdaptor;
import org.apache.tapestry.util.io.IntegerAdaptor;
import org.apache.tapestry.util.io.LongAdaptor;
import org.apache.tapestry.util.io.SerializableAdaptor;
import org.apache.tapestry.util.io.ShortAdaptor;
import org.apache.tapestry.util.io.StringAdaptor;

public class DataSqueezer {
    private static final String NULL_PREFIX = "X";
    private static final char NULL_PREFIX_CH = 'X';
    private static final int ARRAY_SIZE = 90;
    private static final int FIRST_ADAPTOR_OFFSET = 33;
    private ISqueezeAdaptor[] _adaptorByPrefix = new ISqueezeAdaptor[90];
    private AdaptorRegistry _adaptors = new AdaptorRegistry();
    private IResourceResolver _resolver;

    public DataSqueezer(IResourceResolver resolver) {
        this(resolver, null);
    }

    public DataSqueezer(IResourceResolver resolver, ISqueezeAdaptor[] adaptors) {
        this._resolver = resolver;
        this.registerDefaultAdaptors();
        if (adaptors != null) {
            for (int i = 0; i < adaptors.length; ++i) {
                adaptors[i].register(this);
            }
        }
    }

    private void registerDefaultAdaptors() {
        new CharacterAdaptor().register(this);
        new StringAdaptor().register(this);
        new IntegerAdaptor().register(this);
        new DoubleAdaptor().register(this);
        new ByteAdaptor().register(this);
        new FloatAdaptor().register(this);
        new LongAdaptor().register(this);
        new ShortAdaptor().register(this);
        new BooleanAdaptor().register(this);
        new SerializableAdaptor().register(this);
        new ComponentAddressAdaptor().register(this);
        new EnumAdaptor().register(this);
    }

    public synchronized void register(String prefix, Class dataClass, ISqueezeAdaptor adaptor) {
        int prefixLength = prefix.length();
        if (prefixLength < 1) {
            throw new IllegalArgumentException(Tapestry.getMessage("DataSqueezer.short-prefix"));
        }
        if (dataClass == null) {
            throw new IllegalArgumentException(Tapestry.getMessage("DataSqueezer.null-class"));
        }
        if (adaptor == null) {
            throw new IllegalArgumentException(Tapestry.getMessage("DataSqueezer.null-adaptor"));
        }
        for (int i = 0; i < prefixLength; ++i) {
            char ch = prefix.charAt(i);
            if (ch < '!' | ch > 'z') {
                throw new IllegalArgumentException(Tapestry.getMessage("DataSqueezer.prefix-out-of-range"));
            }
            int offset = ch - 33;
            if (this._adaptorByPrefix[offset] != null) {
                throw new IllegalArgumentException(Tapestry.format("DataSqueezer.adaptor-prefix-taken", prefix.substring(i, i)));
            }
            this._adaptorByPrefix[offset] = adaptor;
        }
        this._adaptors.register(dataClass, adaptor);
    }

    public String squeeze(Object data) throws IOException {
        if (data == null) {
            return NULL_PREFIX;
        }
        ISqueezeAdaptor adaptor = (ISqueezeAdaptor)this._adaptors.getAdaptor(data.getClass());
        return adaptor.squeeze(this, data);
    }

    public String[] squeeze(Object[] data) throws IOException {
        if (data == null) {
            return null;
        }
        int length = data.length;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.squeeze(data[i]);
        }
        return result;
    }

    public Object unsqueeze(String string) throws IOException {
        ISqueezeAdaptor adaptor = null;
        if (string.equals(NULL_PREFIX)) {
            return null;
        }
        int offset = string.charAt(0) - 33;
        if (offset >= 0 && offset < this._adaptorByPrefix.length) {
            adaptor = this._adaptorByPrefix[offset];
        }
        if (adaptor == null) {
            return string;
        }
        return adaptor.unsqueeze(this, string);
    }

    public Object[] unsqueeze(String[] strings) throws IOException {
        if (strings == null) {
            return null;
        }
        int length = strings.length;
        Object[] result = new Object[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.unsqueeze(strings[i]);
        }
        return result;
    }

    public boolean isPrefixRegistered(char prefix) {
        int offset = prefix - 33;
        if (prefix == 'X') {
            return true;
        }
        if (offset < 0 || offset >= this._adaptorByPrefix.length) {
            return false;
        }
        return this._adaptorByPrefix[offset] != null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DataSqueezer[adaptors=<");
        buffer.append(this._adaptors.toString());
        buffer.append(">]");
        return buffer.toString();
    }

    public IResourceResolver getResolver() {
        return this._resolver;
    }
}

