/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.html;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.asset.PrivateAsset;
import org.apache.tapestry.resource.ClasspathResourceLocation;
import org.apache.tapestry.util.IdAllocator;

public abstract class Body
extends AbstractComponent
implements IScriptProcessor {
    private StringBuffer _initializationScript;
    private IMarkupWriter _outerWriter;
    private StringBuffer _bodyScript;
    private StringBuffer _imageInitializations;
    private Map _imageMap;
    private List _externalScripts;
    private IdAllocator _idAllocator;
    private static final String ATTRIBUTE_NAME = "org.apache.tapestry.active.Body";

    public String getPreloadedImageReference(String URL2) {
        String reference;
        if (this._imageMap == null) {
            this._imageMap = new HashMap();
        }
        if ((reference = (String)this._imageMap.get(URL2)) == null) {
            int count = this._imageMap.size();
            String varName = "tapestry_preload[" + count + "]";
            reference = varName + ".src";
            if (this._imageInitializations == null) {
                this._imageInitializations = new StringBuffer();
            }
            this._imageInitializations.append("  ");
            this._imageInitializations.append(varName);
            this._imageInitializations.append(" = new Image();\n");
            this._imageInitializations.append("  ");
            this._imageInitializations.append(reference);
            this._imageInitializations.append(" = \"");
            this._imageInitializations.append(URL2);
            this._imageInitializations.append("\";\n");
            this._imageMap.put(URL2, reference);
        }
        return reference;
    }

    public void addInitializationScript(String script) {
        if (this._initializationScript == null) {
            this._initializationScript = new StringBuffer(script.length() + 1);
        }
        this._initializationScript.append(script);
        this._initializationScript.append('\n');
    }

    public void addBodyScript(String script) {
        if (this._bodyScript == null) {
            this._bodyScript = new StringBuffer(script.length());
        }
        this._bodyScript.append(script);
    }

    public void addExternalScript(IResourceLocation scriptLocation) {
        if (this._externalScripts == null) {
            this._externalScripts = new ArrayList();
        }
        if (this._externalScripts.contains(scriptLocation)) {
            return;
        }
        if (!(scriptLocation instanceof ClasspathResourceLocation)) {
            throw new ApplicationRuntimeException(Tapestry.format("Body.include-classpath-script-only", scriptLocation), this, null, null);
        }
        this._externalScripts.add(scriptLocation);
    }

    private void writeExternalScripts(IMarkupWriter writer) {
        int count = Tapestry.size(this._externalScripts);
        for (int i = 0; i < count; ++i) {
            ClasspathResourceLocation scriptLocation = (ClasspathResourceLocation)this._externalScripts.get(i);
            PrivateAsset asset = new PrivateAsset(scriptLocation, null);
            String url = asset.buildURL(this.getPage().getRequestCycle());
            writer.begin("script");
            writer.attribute("language", "JavaScript");
            writer.attribute("type", "text/javascript");
            writer.attribute("src", url);
            writer.end();
            writer.println();
        }
    }

    public static Body get(IRequestCycle cycle) {
        return (Body)cycle.getAttribute(ATTRIBUTE_NAME);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.getAttribute(ATTRIBUTE_NAME) != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("Body.may-not-nest"), this, null, null);
        }
        cycle.setAttribute(ATTRIBUTE_NAME, this);
        this._outerWriter = writer;
        IMarkupWriter nested = writer.getNestedWriter();
        this.renderBody(nested, cycle);
        writer.println();
        writer.begin(this.getElement());
        this.renderInformalParameters(writer, cycle);
        writer.println();
        this.writeScript(this._outerWriter);
        nested.close();
        writer.end();
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        super.cleanupAfterRender(cycle);
        if (this._idAllocator != null) {
            this._idAllocator.clear();
        }
        if (this._imageMap != null) {
            this._imageMap.clear();
        }
        if (this._externalScripts != null) {
            this._externalScripts.clear();
        }
        if (this._initializationScript != null) {
            this._initializationScript.setLength(0);
        }
        if (this._imageInitializations != null) {
            this._imageInitializations.setLength(0);
        }
        if (this._bodyScript != null) {
            this._bodyScript.setLength(0);
        }
        this._outerWriter = null;
    }

    protected void writeScript(IMarkupWriter writer) {
        if (!Tapestry.isEmpty(this._externalScripts)) {
            this.writeExternalScripts(writer);
        }
        if (!(this.any(this._initializationScript) || this.any(this._bodyScript) || this.any(this._imageInitializations))) {
            return;
        }
        writer.begin("script");
        writer.attribute("language", "JavaScript");
        writer.attribute("type", "text/javascript");
        writer.printRaw("<!--");
        if (this.any(this._imageInitializations)) {
            writer.printRaw("\n\nvar tapestry_preload = new Array();\n");
            writer.printRaw("if (document.images)\n");
            writer.printRaw("{\n");
            writer.printRaw(this._imageInitializations.toString());
            writer.printRaw("}\n");
        }
        if (this.any(this._bodyScript)) {
            writer.printRaw("\n\n");
            writer.printRaw(this._bodyScript.toString());
        }
        if (this.any(this._initializationScript)) {
            writer.printRaw("\n\nwindow.onload = function ()\n{\n");
            writer.printRaw(this._initializationScript.toString());
            writer.printRaw("}");
        }
        writer.printRaw("\n\n// -->");
        writer.end();
    }

    private boolean any(StringBuffer buffer) {
        if (buffer == null) {
            return false;
        }
        return buffer.length() > 0;
    }

    public abstract String getElement();

    public abstract void setElement(String var1);

    protected void finishLoad() {
        this.setElement("body");
    }

    public String getUniqueString(String baseValue) {
        if (this._idAllocator == null) {
            this._idAllocator = new IdAllocator();
        }
        return this._idAllocator.allocateId(baseValue);
    }
}

