/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.AbstractService;
import org.apache.tapestry.engine.IEngineServiceView;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.request.ResponseOutputStream;

public class ExternalService
extends AbstractService {
    public ILink getLink(IRequestCycle cycle, IComponent component, Object[] parameters) {
        if (parameters == null || parameters.length == 0) {
            throw new ApplicationRuntimeException(Tapestry.format("service-requires-parameters", "external"));
        }
        String pageName = (String)parameters[0];
        String[] context = new String[]{pageName};
        Object[] pageParameters = new Object[parameters.length - 1];
        System.arraycopy(parameters, 1, pageParameters, 0, parameters.length - 1);
        return this.constructLink(cycle, "external", context, pageParameters, true);
    }

    public void service(IEngineServiceView engine, IRequestCycle cycle, ResponseOutputStream output) throws ServletException, IOException {
        IExternalPage page = null;
        String[] context = this.getServiceContext(cycle.getRequestContext());
        if (context == null || context.length != 1) {
            throw new ApplicationRuntimeException(Tapestry.format("service-single-context-parameter", "external"));
        }
        String pageName = context[0];
        try {
            page = (IExternalPage)cycle.getPage(pageName);
        }
        catch (ClassCastException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("ExternalService.page-not-compatible", pageName), ex);
        }
        Object[] parameters = this.getParameters(cycle);
        cycle.setServiceParameters(parameters);
        cycle.activate(page);
        page.activateExternalPage(parameters, cycle);
        engine.renderResponse(cycle, output);
    }

    public String getName() {
        return "external";
    }
}

